<?php
define ( 'JS_PATH' , get_template_directory_uri().'/library/functions/shortcodes/shortcode.js');

function express_addbuttons() {
	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
		return;

	if ( get_user_option('rich_editing') == 'true') {
		add_filter("mce_external_plugins", "add_alc_custom_tinymce_plugin");
		add_filter('mce_buttons', 'register_alc_custom_button');
	}
}
function register_alc_custom_button($buttons) {
	array_push(
		$buttons,
		"express"
		); 
	return $buttons;
} 

function add_alc_custom_tinymce_plugin($plugin_array) {
	$plugin_array['expressShortcodes'] = JS_PATH;
	return $plugin_array;
}
add_action('init', 'express_addbuttons');

function sumtips_add_dfe_buttons($buttons)
{
	$buttons[] = 'separator'; //Add separator (optional)
	$buttons['expressShortcodes'] = array(
		'title' => esc_html__('Express Shortcodes', "express"), //Button Title
		'onclick' => "tinyMCE.execCommand('alc_express');", //Command to execute
		'both' => true // Show in visual mode. Set 'true' to show in both visual and HTML mode
	);
	
	return $buttons;
}
add_filter( 'wp_fullscreen_buttons', 'sumtips_add_dfe_buttons' );

/********************* PANEL **********************/

function alc_panel( $atts, $content = null ) {
	extract(shortcode_atts(array(
		"anim"=>'',
		"color" => 'panel-default',
        "head"=>'',
        "footer"=>'',
        "class"=>''
	), $atts));
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$out = '<div class="panel '.$color.' '.$anim.' '.$class.'">';
	if ($head) $out.='<div class="panel-heading"><span class="panel-title">'.$head.'</span></div>';
        $out.='<div class="panel-body">'.do_shortcode ($content).'</div>';
        if($footer) $out.= '<div class="panel-footer"><span class="panel-title">'.$footer.'</span></div>';
        $out.='</div>';
    return $out;
}
add_shortcode('panel', 'alc_panel');

/**************************************************/

/***************** PROGRESS BAR *******************/

function alc_progressbar( $atts, $content = null ) {
    extract(shortcode_atts(array(
		"anim"=>'',
		"color"=>'info',
		"customcolor" => '',
		"meter" => '10',
		"style" => '',
		"animated" => '',
		"title" => '',
		"class"=>''
	), $atts));
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	if ($customcolor) $customcolor = '; background-color:'.$customcolor.' !important';
	$out='';
	
		if($title){$out.='<h4 class="progress-title">'.$title.'<span>'.$meter.'%</span></h4>';}
		$out.='<div class="progress '.$style.' '.$animated.' '.$class.'  '.$anim.'">
  			<div class="progress-bar progress-bar-'.$color.'  " role="progressbar" aria-valuenow="'.$meter.'" aria-valuemin="0" aria-valuemax="100" style="width:'.$meter.'% '.$customcolor.'">';
		   $out.='</div>
				</div>';
			
    return $out;
}
add_shortcode('progressbar', 'alc_progressbar');

/************************************************/


/*************** Dropdown buttons *****************/

function alc_dropbutton_group( $atts, $content ){
	extract(shortcode_atts(array(
		'title' => '',
		'type'	=> '',
		'color' => 'btn-primary',
		'anim'=>'',
		'class'=>'',
	), $atts));
	$GLOBALS['dropbutton_count'] = 0;
	$randomId = mt_rand(0, 100000);
	$return = '';
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	do_shortcode( $content );
	$counter = 1;
	if( is_array( $GLOBALS['dropbuttons'] ) ){
		foreach( $GLOBALS['dropbuttons'] as $dropbutton ){
			$dropbuttons[] = '<li><a href="'.$dropbutton['url'].'">'.do_shortcode($dropbutton['title']).'</a></li>';
			if ($dropbutton['divider'] == 1)
			{
				$dropbuttons[] = '<li class="divider"></li>';
			}
		}
		
		if ($type == 'split')
		{
			$return.='
			<div class="btn-group '.$anim.' '.$class.'">
				<button class="btn '.$color.' ">'.$title.'</button>
				<button class="btn dropdown-toggle '.$color.'" data-toggle="dropdown">
					<span class="caret "></span>
				</button>';
		}
		else
		{	
			$return.= '
			<div class="btn-group '.$anim.' '.$class.'">
				 <a class="btn  dropdown-toggle '.$color.'" data-toggle="dropdown" href="#">'.$title.'<span class="caret icon-right"></span></a>';
		}
		$return.= '<ul class="dropdown-menu" id="'.$randomId.'">'.implode( "\n", $dropbuttons ).'</ul>';
		$return.= '</div>';
		unset($GLOBALS['dropbuttons']);
	}
	return $return;
}
add_shortcode( 'dropbuttongroup', 'alc_dropbutton_group' );

/**************************************************/


/**************** DROPDOWN BUTTON *****************/

function alc_dropbutton( $atts, $content ){
	extract(shortcode_atts(array(
	'title' => '',
	'url' => '',
	'divider' => '0',
	), $atts));
	
	$x = $GLOBALS['dropbutton_count'];
	$GLOBALS['dropbuttons'][$x] = array( 'title' => $title, 'url' => $url, 'divider' => $divider, 'content' =>  $content );
	
	$GLOBALS['dropbutton_count']++;
}

add_shortcode( 'dropbutton', 'alc_dropbutton' );

/************************************************/

/******************* BUTTONS ********************/

function alc_button( $atts, $content = null ) {
	extract(shortcode_atts(array(
		'link' => '#',
		'color' => 'btn-default',
		'target' => '',
		'size' => 'defaultsize',
		'status'=>'',
		'anim'=>'',
		'class'=>'',
		'icon'=>'',
		'family'=>'fa'
	), $atts));
    
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$target = ($target) ? ' target="_blank"' : '';
	$out='';
	$out.='<a href="'.$link.'" '.$target.' class="btn  '.$size.' '.$color.' '.$status.'  '.$class.' '.$anim.'">';
	$out.=do_shortcode($content);
	if($icon){$out.='<i class="'.$family.' '.$icon.'"></i>';}
	$out.='</a>';
    return $out;
}
add_shortcode('button', 'alc_button');

/************************************************/


/****************** TABS ************************/

function alc_tab_group( $atts, $content ){
    extract(shortcode_atts(array(
        'anim'=>'',
        'class'=>'',
        ), $atts));
	$GLOBALS['tab_count'] = 0;	
	do_shortcode( $content );
    
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$randomId = mt_rand(0, 100000);
	$counter = 0;
		if( is_array( $GLOBALS['tabs'] ) ){
			foreach( $GLOBALS['tabs'] as $tab ){
				$active = ($counter == 0) ? ' active' : '';
				$activecontent = ($counter == 0) ? ' active in' : '';
				$tabs[] = '  <li  class="'.$active.'"><a href="#tab-'.$randomId.'"  data-toggle="tab">';
				$tabs[].= $tab['title'].'</a></li>';
				$tabcontent[] =  '<div  class="tab-pane fade '.$activecontent.'" id="tab-'.$randomId.'">'.do_shortcode($tab['content']).'</div>';	
				$counter ++;
				$randomId++;
			}
			$return='';
			$return.='<div class="tabpanel tabs-shortcode  '.$anim.' '.$class.' ">';
				$return.= '<ul class="nav nav-tabs">'.implode( "\n", $tabs ).'</ul>';
				$return.= ' <div class="tab-content">'.implode( "\n", $tabcontent ).'</div>';
			$return.='</div>';
			unset($GLOBALS['tabs']);
		}
	return $return;
}
add_shortcode( 'tabgroup', 'alc_tab_group' );


function alc_tab( $atts, $content ){
	extract(shortcode_atts(array(
	'title' => 'Tab %d',
	
	), $atts));
	
	$x = $GLOBALS['tab_count'];
	$GLOBALS['tabs'][$x] = array( 'title' => sprintf( $title, $GLOBALS['tab_count'] ), 'content' =>  $content);
	
	$GLOBALS['tab_count']++;
}
add_shortcode( 'tab', 'alc_tab' );

/************************************************/
/*************** Vertical Navigation ************/
function alc_vernav_group( $atts, $content ){
	extract(shortcode_atts(array(
		'title' => '',
		'anim'=>'',
		'class'=>'',
	), $atts));
	$GLOBALS['vernav_count'] = 0;
	do_shortcode( $content );
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$return = '<div class="vernav '.$anim.' '.$class.'" style="max-width: 340px; padding: 8px 0"><ul class="nav nav-list">';
	if (!empty($title)) $return.='<li class="nav-header">'.$title.'</li>';
	if( is_array( $GLOBALS['vernavs'] ) ){
		foreach( $GLOBALS['vernavs'] as $vernav ){
			$vernavs[] = ' 
				<li><a href="'.$vernav['link'].'">'.$vernav['title'].'</a></li>';	
		}
		$return.=implode( "\n", $vernavs );
		$return.= '</ul></div>';
		unset($GLOBALS['vernavs']);
	}
	return $return;
}
add_shortcode( 'vernavgroup', 'alc_vernav_group' );


function alc_vernav( $atts, $content ){
	extract(shortcode_atts(array(
	'title' => 'Nav %d',
	'link'	=> ''
	), $atts));
	
	$x = $GLOBALS['vernav_count'];
	$GLOBALS['vernavs'][$x] = array( 'title' => sprintf( $title, $GLOBALS['vernav_count'] ), 'content' =>  $content, 'link' =>  $link );
	
	$GLOBALS['vernav_count']++;
}
add_shortcode( 'vernav', 'alc_vernav' );

/*************************************************/


/***************** ACCORDION ********************/


function alc_accordion_group( $atts, $content ){
	extract(shortcode_atts(array(
        'type'=>'1',
        'anim'=>'',
        'class'=>'',
	), $atts));
	$GLOBALS['accordion_count'] = 0;
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$counter = 0;
	$accId=  mt_rand(0, 100);
	do_shortcode( $content );
        
	if($type==1){
		$acc='data-parent="#accordion-'.$accId.'"';
	}
	else{
		$acc="";
	}
        
	if( is_array( $GLOBALS['accordions'] ) ){
		foreach( $GLOBALS['accordions'] as $accordion ){
			$randomId=  mt_rand(0, 10000);
			$active = ($counter == 0) ? ' ' : 'collapsed';
			$activeContent=($counter==0 )? 'in' : '';
			$accordions[] = '
				<div class="panel panel-default">
					<div class="panel-heading">
						<h4 class="panel-title">
							<a class="accordion-toggle collapsed-icon '.$active.'" '.$acc.' data-toggle="collapse" href="#acc-'.$randomId.'">';
								$accordions[].= $accordion['title'].'
							</a>
						</h4>
					</div>
					<div id="acc-'.$randomId.'" class="panel-collapse collapse '.$activeContent.'">
						<div class="panel-body">'.do_shortcode($accordion['content']).'</div>
					</div>
				</div>';
			$counter++;
		}
		$return='<div class="acc-shortcode panel-group '.$anim.' '.$class.' " id="accordion-'.$accId.'">'.implode( "\n", $accordions ).'</div>';
		unset($GLOBALS['accordions']);
	}
	return $return;
}

add_shortcode( 'accordiongroup', 'alc_accordion_group' );
/***************/

function alc_accordion( $atts, $content ){
	extract(shortcode_atts(array(
	'title' => 'accordion %d',
	), $atts));
	
	$x = $GLOBALS['accordion_count'];
	$GLOBALS['accordions'][$x] = array( 'title' => sprintf( $title, $GLOBALS['accordion_count'] ), 'content' =>  $content);
	
	$GLOBALS['accordion_count']++;
}

add_shortcode( 'accordion', 'alc_accordion' );
/************************************************/


/*************** TESTIMONIALS ********************/

function alc_testimonial_group( $atts, $content ){
	extract(shortcode_atts(array(
        'anim'=>'',
        'class'=>'',
		'nav'=>'true',
		'pag'=>'true',
		'rtl'=>'false',
		'auto'=>'true',
		'interval'=>'3000'
	), $atts));
	$GLOBALS['testimonial_count'] = 0;
	$counter = 0;
	$randomId = mt_rand(0, 100000);
	do_shortcode( $content );
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$return="";
	$return.='<div id="testimonials-'.$randomId.'" class="testimonials-box testimonial-slider  '.$anim.' '.$class.'">';
					if( is_array( $GLOBALS['testimonials'] ) ){
						foreach( $GLOBALS['testimonials'] as $testimonial ){
						$imglink='';
						if(function_exists('vc_map')){
							$limage = wp_get_attachment_image_src($testimonial['photo'], 'full');
							$imglink.=$limage[0];
						}else{
							$imglink=$testimonial['photo'];
						}
						$testimonials[]='<div class="col-md-12">
											<div class="testimonials-content">
												<i><img src="'.$imglink.'" alt="'.$testimonial['title'].'"/></i>
												<p>'.do_shortcode($testimonial['content']).' </p>
												<h3>'.$testimonial['title'].' <span>('.$testimonial['position'].')</span></h3>
											</div>
										</div>';
						
				$counter++;
			}
			$return.= implode( "\n", $testimonials );
			unset($GLOBALS['testimonials']);
		}
	$return.='</div>';		
	$direction= weblusive_get_option('rtl_mode');
	if($direction){
		$rtl='true';
	}else{
		$rtl='false';
	}
	$return.='<script type="text/javascript">
		jQuery(document).ready(function(){
			jQuery("#testimonials-'.$randomId.'").owlCarousel({
				rtl:'.$rtl.',
				loop: true,
				margin:0,
				autoplay: '.$auto.',
				autoplayTimeout:'.$interval.',
				nav: '.$nav.',
				dots:'.$pag.',
				responsive:{
					0:{
						items:1
					},
					600:{
						items:1
					},
					1000:{
						items:2
					}
				}
		});
	});
	</script>';

	return $return;
}

add_shortcode( 'testimonialgroup', 'alc_testimonial_group' );

function alc_testimonial( $atts, $content ){
	extract(shortcode_atts(array(
		'title' => '',
		'position' => '',
		'photo'=>'',

	), $atts));
	
	$x = $GLOBALS['testimonial_count'];
	$GLOBALS['testimonials'][$x] = array( 'title' => sprintf( $title, $GLOBALS['testimonial_count'] ), 'position' => $position,  'photo' => $photo,  'content' =>  $content );
	
	$GLOBALS['testimonial_count']++;
}

add_shortcode( 'testimonial', 'alc_testimonial' );

/************************************************/

/******************* Alertbox *******************/

function alc_alert( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"type"=>'alertdefault',
		"color" => 'alert-warning',
		"anim"=>'',
		"class"=>''
	), $atts));
    do_shortcode($content);
	$icon='';
	if($color=='alert-success'){
		$icon.='<span class="icon"><i class="fa fa-check"></i></span>';
	}elseif ($color=='alert-info') {
		$icon.='<span class="icon"><i class="fa fa-info-circle"></i></span>';
	}elseif ($color=='alert-danger') {
		$icon.='<span class="icon"><i class="fa fa-exclamation-circle"></i></span>';
	}elseif($color=='alert-warning'){
		$icon.='<span class="icon"><i class="fa fa-warning"></i></span>';
	}
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$out = '<div class="alert '.$type.' '.$color.' '.$class.' '.$anim.'" role="alert">';
     if($type!=='alertdefault') {$out.='<button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only">Close</span></button>';}
	$out.=$icon.'<span class="message">'.do_shortcode($content).'</span></div>';
   return $out;
}
add_shortcode('alert', 'alc_alert');

/************************************************/


/***********  VIDEOS  ****************/

function alc_video($atts, $content=null) {
	extract(shortcode_atts(array(
			'site' => 'youtube',
			'id' => '',
			'width' => '',
			'height' => '',
			'autoplay' => '0',
			"anim"=>'',
			"class"=>''
		), $atts)
	);
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	if ( $site == "youtube" ) { $src = 'http://www.youtube.com/embed/'.$id.'?autoplay='.$autoplay; }
	else if ( $site == "vimeo" ) { $src = 'http://player.vimeo.com/video/'.$id.'?autoplay='.$autoplay; }
	else if ( $site == "dailymotion" ) { $src = 'http://www.dailymotion.com/embed/video/'.$id.'?autoplay='.$autoplay; }
	else if ( $site == "veoh" ) { $src = 'http://www.veoh.com/static/swf/veoh/SPL.swf?videoAutoPlay='.$autoplay.'&permalinkId='.$id; }
	else if ( $site == "bliptv" ) { $src = 'http://a.blip.tv/scripts/shoggplayer.html#file=http://blip.tv/rss/flash/'.$id; }
	else if ( $site == "viddler" ) { $src = 'http://www.viddler.com/embed/'.$id.'e/?f=1&offset=0&autoplay='.$autoplay; }
	
	if ( $id != '' ) {
		return '<div class="flex-video '.$anim.' '.$class.'"><iframe width="'.$width.'" height="'.$height.'" src="'.$src.'" class="vid iframe-'.$site.'"></iframe></div>';
	}
}
add_shortcode('tp_video','alc_video');

/************************************************/



/****************** SLIDER ********************/
function alc_slider( $atts, $content ){
	$GLOBALS['slideritem_count'] = 0;
	extract(shortcode_atts(array(
		"anim"=>'',
		"class"=>'',
		"type"=>'single',
		"nav"=>'true',
		"pag"=>'',
		"auto"=>'true',
		"speed" => '3000',
		"sitems"=>'4'
	), $atts));
	do_shortcode( $content );
	$randomId = mt_rand(0, 100000);
	$return = '';
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	
	if(isset($GLOBALS['sitems']) && is_array( $GLOBALS['sitems'] ) ){
		$icount = 0;
		foreach( $GLOBALS['sitems'] as $item ){
			$imglink='';
			if(function_exists('vc_map')){
				$limage = wp_get_attachment_image_src($item['image'], 'full');
				$imglink.=$limage[0];
			}else{
				$imglink=$item['image'];
			}
			$item['logolink']=($item['logolink']) ? $item['logolink'] : '#';
			$panes[]='';
			if($type=='single'){
				$panes[].='<div class="col-md-12 col-sm-12 no-padding" >
							<img src="'.$imglink.'" class="img-responsive">
						</div>';
			}else{
				
				$panes[].='<div class="item"><a href="'.$item['logolink'].'"><img src="'.$imglink.'"  alt="carousel-img" /></a></div>';
			}  		
			$icount ++ ;
		}
		$randomId = mt_rand(0, 100000);
		if($type=='single'){
			$return.='<div id="welcome-slider-'.$randomId.'" class="mission-image slider-shortcode '.$class.' '.$anim.'">
							'.implode( "\n", $panes ).'
					</div>';
		}else{
			$return.='<div id="clients-slider-'.$randomId.'" class="partners-logos '.$class.' '.$anim.'">
						'.implode( "\n", $panes ).'
					</div>';
		}
			
		unset($GLOBALS['sitems']);
	}
	$rtl= weblusive_get_option('rtl_mode');
	if($rtl){
		$rtl='true';
	}else{
		$rtl='false';
	}
	$return.='<script type="text/javascript">
				jQuery(document).ready(function(){';
				if($type=='single'){
					$return.='jQuery("#welcome-slider-'.$randomId.'").owlCarousel({
								rtl	:'.$rtl.',
								loop:true,
								margin:0,
								nav:'.$nav.',
								dots:false,
								autoplay: '.$auto.',
								autoplayTimeout:'.$speed.',
								responsive:{
									0:{
										items:1
									},
									600:{
										items:1
									},
									1000:{
										items:1
									}
								}
							})';
				}else{
					$return.='jQuery("#clients-slider-'.$randomId.'").owlCarousel({
								rtl	:'.$rtl.',
								dots : false,
								loop: true,
								nav: '.$nav.',
								autoplay: '.$auto.',
								autoplayTimeout:'.$speed.',
								items : '.$sitems.',
								responsive: {
									0: {
										items: 1
									},
									768: {
										items: 4
									},
									1200: {
										items: '.$sitems.',
									}
								}
							});';
				}
	$return.='})
			</script>';
	return $return;
}
add_shortcode('slider', 'alc_slider' );

/****/



function alc_slideritem( $atts, $content ){
	extract(shortcode_atts(array(
		'image' => '',
		'title' => '',
		'logolink'=>''
	), $atts));
	
	$x = $GLOBALS['slideritem_count'];
	$GLOBALS['sitems'][$x] = array( 'image' => $image, 'title' => $title, 'content' =>  $content, 'logolink' =>  $logolink );
	
	$GLOBALS['slideritem_count']++;
	
}
add_shortcode( 'slideritem', 'alc_slideritem' );

/************************************************/


/*******************Carousel********************/

function alc_carousel( $atts, $content ){
	$GLOBALS['caritem_count'] = 0;
	extract(shortcode_atts(array(
		'nav' => 'true',
		'pag' => 'true',
		'auto' => 'true',
		'speed'=>'3000',
		'sitems' => '3',
		"anim"=>'',
		"class"=>''
	), $atts));
	$randomId = mt_rand(0, 100000);
	$panes = array();	
	$return = '';
	
	do_shortcode ($content);
   $anim=(!empty($anim)) ? 'animation '.$anim : '';
	if(isset( $GLOBALS['caritems']) && is_array( $GLOBALS['caritems'] ) ){
		foreach( $GLOBALS['caritems'] as $item ){
			$panes[]='<div class="col-md-12"><div class="item">'.$item['content'].'</div></div>';										
		}
		$return.='<div id="conent-slider-'.$randomId.'" class="content-slider  owl-carousel'.$class.' '.$anim.'">
						'.implode( "\n", $panes ).'
					</div>';
		unset($GLOBALS['caritems']);
	}
	
	$rtl= weblusive_get_option('rtl_mode');
	if($rtl){
		$rtl='true';
	}else{
		$rtl='false';
	}
	$return.='<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery("#conent-slider-'.$randomId.'").owlCarousel({
						rtl	:'.$rtl.',
								nav : '.$nav.', // Show next and prev buttons
								dots:'.$pag.',
								items : '.$sitems.',
								autoplay: '.$auto.',
								autoplayTimeout:'.$speed.',
								loop:true,
								margin:0,
								responsiveClass:true,
								responsive:{
									0:{
										items:1,
									},
									600:{
										items:2,
									},
									1000:{
										items:'.$sitems.',
									}
								}
					});';
	$return.='})
			</script>';
	return $return;
}

add_shortcode('carousel', 'alc_carousel' );
/***/

function alc_caritem( $atts, $content ){
	extract(shortcode_atts(array(
	'title' => '',
	), $atts));
	$x = $GLOBALS['caritem_count'];
	$GLOBALS['caritems'][$x] = array('title' => $title, 'content' =>  do_shortcode ($content) );
	$GLOBALS['caritem_count']++;	
}
add_shortcode( 'caritem', 'alc_caritem' );

/************************************************/


/*************** Contact details ****************/

function alc_contact( $atts, $content = null ) {
     extract(shortcode_atts(array(
		"type"=>"horizontal",
		"color"=>"color-default",
		"address" => '',
		"tel" => '',
		"email" => '',
		"fax" => '',
		"whour"=>"",
		"anim"=>'',
		"class"=>'',
	), $atts));	
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$out='';
	$mainClass=($type=='horizontal') ? 'list-inline contact-horizontal' : 'contact-vertical';
		$out.='<ul class="'.$mainClass.' '.$class.' '.$anim.' '.$color.'">';
					if($address) {$out.='<li><i class="fa fa-paper-plane-o"></i>' . $address . '</li>';}
					if ($tel) {$out.='<li><i class="fa fa-phone"></i>' . $tel . '</li>';}
					if ($email) {$out.='<li><i class="fa fa-envelope-o"></i>' . $email . '</li>';}
					if ($fax) {$out.='<li><i class="icon_printer"></i>' . $fax . '</li>';}
					if ($whour) {$out.='<li><i class="icon_clock_alt"></i>' . $whour . '</li>';}
		$out.=' </ul>';                                       
	
   return $out;
}
add_shortcode('contact', 'alc_contact');

/************************************************/


/************ FEATURED BLOCK****************/
function alc_fblock($atts, $content=NULL){
    extract(shortcode_atts(array(
        'anim'=>'',
		'type' => 'default',
		'title' => '',
		'family' => 'fa',
		'icon' => '',
		'class'=>'',
		'color' => '',
		'sectext'=>'',
    ), $atts));
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	
	
	$sizes = '';
	if(function_exists('getimagesize') && !empty($imglink)){
		$sizes = @getimagesize($imglink);
		$sizes = $sizes[3];
	}
	
	$out = '';
	if($type=='default'){
		$out.='<div class="offers-content fblock1  '.$anim.' '.$class.'">
					<i class="'.$family.' '.$icon.'"></i>
					<h3>'.$title.'</h3>
					<p>'.do_shortcode($content).'</p>
				</div>';
	}elseif($type=='alter'){
		$out.='<div class="fblock2  '.$anim.' '.$class.'">
					<i class="'.$family.' '.$icon.'"></i>
					<h3>'.$title.'</h3>
					<p>'.do_shortcode($content).'</p>
				</div>';
	}elseif($type=='alter2'){
		$out.='<div class="fblock3  '.$anim.' '.$class.' '.$color.'">
					<i class="'.$family.' '.$icon.'"></i>
					<h3><span>'.$sectext.'</span><b>'.$title.'</b></h3>
				</div>';
	}
		
				
	return $out;
}
add_shortcode('fblock', 'alc_fblock');

/*****************************************************/


/***************TITLE BLOCK***************************/
function alc_tblock($atts, $content=NULL){
    extract(shortcode_atts(array(
        'anim'=>'',
		'type'=>'tblock-default',
        'title'=>'',
		'sectext'=>'',
		'tag'=>'h1',
		'tcuscolor'=>'',
		'color'=>'',
		'pos'=>'text-left',
        'class'=>'',
		'family' => 'fa',
		'icon' => '',
    ), $atts));
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$tcuscolor = (isset($tcuscolor) && !empty($tcuscolor))  ? $tcuscolor : '';
	$out='';
	if($type=='tblock-default'){
		$out.='<div class="section-header '.$type.' '.$pos.' '.$class.' '.$anim.' '.$color.'">
				<'.$tag.' class="tblock " style="color:'.$tcuscolor.' !important;">';
				$out.=$title;
				$out.='</'.$tag.'><p style="color:'.$tcuscolor.' !important;">'.$sectext.'</p>
			</div>';
	}elseif($type=='tblock-alter'){
		$out.='<div class="section-header '.$type.' '.$pos.' '.$class.' '.$anim.' '.$color.'">
				<i class="'.$family.' '.$icon.'" style="color:'.$tcuscolor.' !important;"></i>
				<'.$tag.' class="tblock " style="color:'.$tcuscolor.' !important;">';	
				$out.=$title;
				$out.='</'.$tag.'><p style="color:'.$tcuscolor.' !important;">'.$sectext.'</p>
			</div>';
	}
    return $out;
}

add_shortcode('tblock', 'alc_tblock');

/******************************************************/


/******************** REVEAL BOX **********************/

function alc_reveal($atts, $content=NULL){
    extract(shortcode_atts(array(
        'type'=>'btn',
        'size'=>'btn-lg',
        'color'=>'btn-default',
        'button'=>'', 
        'revtitle'=>'',
		'noclosebutton' => 'false',
        'class'=>''
    ), $atts));
    $randomId=  mt_rand(0, 100000);
   if($type=='btn'){
	   $output=$color.' '.$size;
	   
   }else{
	   $output='';
   }
    $out='<a href="#myModal'.$randomId.'"  role="button" data-toggle="modal" class="'.$type.' '.$output.'  '.$class.'">'.$button.'</a>';
    $out.='<div id="myModal'.$randomId.'"  class="modal fade" role="dialog" aria-labelledby="myModalLabel" aria-hidden="false">
            <div class="modal-dialog">
            <div class="modal-content">        
            <div class="modal-header">
		<h4 id="myModalLabel">'.$revtitle.'</h4>
	  </div>
	   <div class="modal-body">
		<p>'.do_shortcode($content).'</p>
	  </div>';
	  if ($noclosebutton == 'false'):
	  $out.='<div class="modal-footer"><button class="btn" data-dismiss="modal" aria-hidden="true">'.esc_html__('Close', 'express').'</button></div>';
	  endif;
         $out.='</div>
          </div>
	 </div>
	';	
return $out;
}

add_shortcode('reveal', 'alc_reveal');

/*************************************************/


/************** PORTFOLIO LISTING ***************/

function alc_portlisting($atts, $content=NULL){
    extract(shortcode_atts(array(
		"limit" => 6,
		"featured" => 0,
		'class'=>'',
		'filter' => 'true'
		), $atts));
 	global $post;
	$return = '';
    $counter = 0; 
	$randomId=  mt_rand(0, 10000);
//	$isActive = 'active';
	$args = array('post_type' => 'portfolio', 'taxonomy'=> 'portfolio_category', 'showposts' => $limit, 'posts_per_page' => $limit, 'orderby' => 'date','order' => 'DESC');
	
	if ($featured)
	{
		$args['meta_query'] = array(array('key'=>'_portfolio_featured'));
	}
	
   	$query = new WP_Query($args);
	$return.='<div id="projects" class="home-works1 portfolio-wrapper '.$class.'">';
		if($filter=='true'):
			 $return.='<div class="container">
						<div id="portfolio-filters" class="portfolio-filters text-center">
						<ul class="non-paginated" id="filters">
							<li><a  class="active" data-filter="*">'. esc_html__('All', 'express').'</a></li>';
							$cats = get_post_meta($post->ID, "_page_portfolio_cat", $single = true);
							$MyWalker = new PortfolioWalker();
							$argsfilter = array( 'taxonomy' => 'portfolio_category', 'hide_empty' => '0', 'include' => $cats, 'title_li'=> '', 'walker' => $MyWalker, 'echo' => '0');
							$categories = wp_list_categories ($argsfilter);
							$return.= $categories.'</ul>
						</div>
					</div>';
		endif; 
		$return.='<div id="portfolio" class="portfolio">
					<div class="portfolio-sizer"></div>';
	if ($query->have_posts()):  
		while ($query->have_posts()) : 							
			$query->the_post();
			$custom = get_post_custom($post->ID);
			$cats = wp_get_object_terms($post->ID, 'portfolio_category');
			if ($cats):
				$cat_slugs = '';
				$cat_name='';
				foreach( $cats as $cat ) {$cat_slugs .= $cat->slug . " "; $cat_name.=$cat->name. " ";}
			endif;
			$link = ''; $thumbnail = get_the_post_thumbnail($post->ID, 'express-portfolio-list'); 
			$size = isset($custom["_portfolio_item_size"][0]) ? $custom["_portfolio_item_size"][0] : '';
			//if ($counter == 0 || $counter % 4 == 0): $return.='<div class="item"><div class="row">'; endif;
			$return.='<div class="item  '.esc_attr($size).' '.esc_attr($cat_slugs).'">
							<div class="overlay"></div>';
						if (!empty($thumbnail)): 
							$return.=$thumbnail; 
						else :
							//$return.='<img src = "http://placehold.it/381x254.jpg" alt="' . esc_html__('No image', 'express') . '" />';
						endif;						
						$return.='<div class="portfolio-icons" role="group">';
										if (!empty($custom['_portfolio_video'][0])) : $link = $custom['_portfolio_video'][0]; 
											$return.='<a href="'.$link .'" class="port-icon" data-rel="nivo" data-title="'.get_the_title().'">
														<i class="fa fa-film"></i>
													</a>';
											
										elseif (isset($custom['_portfolio_link'][0]) && $custom['_portfolio_link'][0] != '') : 
											$return.='<a href="'.$custom['_portfolio_link'][0].'" class="port-icon" data-title="'.get_the_title().'">
														<i class="fa fa-external-link"></i>
													</a>';
													
										elseif (isset($custom['_portfolio_no_lightbox'][0]) && $custom['_portfolio_no_lightbox'][0] != '') : $link = get_permalink(get_the_ID()); 
											$return.='<a href="'.$link.'" class="port-icon"  title="'.get_the_title().'">
														<i class="fa fa-file-text-o"></i>
													</a>';
										 else : 
											$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full', false);
											$link = $full_image[0];
											$return.='<a  href="'.$link.'" class="port-icon" data-rel="nivo" data-title="'.get_the_title().'">
														<i class="fa fa-plus-circle"></i>
													</a>';
										endif; 
						$return.='</div>
							<div class="content-wrapper">
								<div class="content">
									<span class="title">'.get_the_title().'</span>
									<a href="'.get_permalink(get_the_ID()).'" class="button white no-border">See Detail</a>
								</div>
							</div>
						</div>';
				//if ($counter >0 && ($counter+1) % 4 == 0): $return.='</div></div>'; endif;							
				$counter ++; endwhile; 
				endif;
	$return.='</div></div>';
	return $return;
}

add_shortcode('portlist', 'alc_portlisting');
/*************************************************/




/****** SHOW POSTS BY CATEGORY AND COUNT ********/

function alc_list_posts( $atts )
{
	extract( shortcode_atts( array(
		'category' => '',
		'limit' => '3',
		'order' => 'DESC',
		'orderby' => 'date',
		'anim'=>'',
		'class'=>'',
	), $atts) );
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$return = '';

	$query = array();

	if ( $category != '' )
		$query[] = 'category=' . $category;

	if ( $limit )
		$query[] = 'numberposts=' . $limit;

	if ( $order )
		$query[] = 'order=' . $order;

	if ( $orderby )
		$query[] = 'orderby=' . $orderby;

	$posts_to_show = get_posts( implode( '&', $query ) );
	$return.='<div id="blogPosts" class=" bloglisting blog-section '.$class.' '.$anim.'">';
				foreach ($posts_to_show as $ps) {
				$showmeta =weblusive_get_option('blog_meta_show') ; 
				$showrmtext = weblusive_get_option('blog_show_rmtext'); 
				$day = get_the_time('d', $ps->ID);
				$month = get_the_time('M', $ps->ID);
				$year = get_the_time('Y', $ps->ID);
				$thumbnail = get_the_post_thumbnail($ps->ID, 'express-blog-thumb-3');
				$postmeta = get_post_custom($ps->ID);
					$return.='<div class="blog-list">
								<div class="row">
									<div class="col-md-4">
										<div class="entry-cover">
											<a href="' . get_permalink($ps->ID) . '">';
												if (!empty($thumbnail)):
																$return.=$thumbnail;
														else:
															//$return.='<img src = "http://placehold.it/155x117" alt="' . esc_html__('No image', 'express') . '" />';
														endif;
									$return.='</a>
										</div>
									</div>
									<div class="col-md-8">
										<div class="blog-area">
											<div class="enetry-header">
												<div class="entry-title">
													<h3><a href="' . get_permalink($ps->ID) . '">'.$ps->post_title.'</a></h3>
												</div>
												<div class="entry-meta">
													<div class="post-date">
														'.$month.' '.$day.', '.$year.'
													</div>
													<div class="byline"> 
														By '.get_the_author().'
													</div>
													<div class="post-comment">
														'.get_comments_number($ps->ID ).' Comments
													</div>
												</div>
											</div>
											<div class="entry-content">
												<p>'.limit_words($ps->post_excerpt, 20).'</p>
											</div>
										</div>
									</div>
								</div>
							</div>';											
			}
			$return.='</div>';

                  
	
	return $return;
}

add_shortcode('list_posts', 'alc_list_posts');

/************************************************/


/**************** RELATED POSTS *****************/
function related_posts_shortcode( $atts ) {
	extract(shortcode_atts(array(
        'count' => '3',
		'title' => 'More useful tips',
	), $atts));
	global $post, $wp_embed;
	$retval = '';
	$current_cat = get_the_category($post->ID);
	$current_cat = $current_cat[0]->cat_ID;
	$this_cat = '';
	$tag_ids = array();
	$tags = get_the_tags($post->ID);
	if ($tags) {
		foreach($tags as $tag) {
			$tag_ids[] = $tag->term_id;
		}
	} 
	else {
		$this_cat = $current_cat;
	}
	$args = array(
		'post_type' => get_post_type(),
		'numberposts' => $count,
		'orderby' => 'date',
		'order' => 'DESC',
		'tag__in' => $tag_ids,
		'cat' => $this_cat,
		'exclude' => $post->ID
	);
	$dtwd_related_posts = get_posts($args);
	if ( empty($dtwd_related_posts) ) {
		$args['tag__in'] = '';
		$args['cat'] = $current_cat;
		$dtwd_related_posts = get_posts($args);
	}
	//if ( empty($dtwd_related_posts) ) {return;}
	$post_list = '';

	if ( $dtwd_related_posts ) {
		foreach($dtwd_related_posts as $r) {
			$get_meta = get_post_custom($r->ID);
			$video = isset($get_meta["_blog_video"]) ? $get_meta["_blog_video"][0] : ''; 
			$thumbnail = get_the_post_thumbnail($r->ID, 'blog-medium');
			$retval .= '
			<div class="col-md-4 col-sm-4">
				<div class="related-post-media">';
					if ($video):
						$retval.='<div class="flex-video">'.$wp_embed->run_shortcode('[embed width="262" height="197"]'.$video.'[/embed]').'</div>';	
					else:	
						if ($thumbnail !== ''):
							$retval.=$thumbnail;
						else:	
							//$retval.='<img src = "http://placehold.it/550x403" alt="'.esc_html__('No Image', 'express').'" />';
						endif;
					endif;		
				$retval .= '</div>
				<div class="related-post-content">
					<div class="related-post-title"><a href="'.get_permalink($r->ID).'">'.wptexturize($r->post_title).'</a></div>
					<div class="related-post-meta"><span class="meta-date">'.get_the_time('d M Y', $r->ID).'</span></div>
				</div>
			</div>';
		}
	} 
	else {
		$retval .= '<div class="col-md-12"><p>'.esc_html__('No related posts for this one', 'express').'</div>';
	}
	
	return $retval;
}
add_shortcode('related_posts', 'related_posts_shortcode');

/*************** SOCIAL BUTTONS *****************/
function alc_social($atts, $content=NULL){
    extract( shortcode_atts( array(
		'anim'=>'',
        'class'=>'',
		'target' => '_blank'
	), $atts) );
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
    $GLOBALS['socbuttoncount']=0;
	$out = '';
	if ($target) $target = 'target="'.$target.'"';
	do_shortcode ($content);
    if(isset($GLOBALS['soc_buttons']) && is_array($GLOBALS['soc_buttons'])){
        foreach ($GLOBALS['soc_buttons'] as $soc){
            $soclink=$soc['link'];
            $socicon=$soc['icon'];
            $soc_buttons[]="<li><a href=\"$soclink\" $target><i class=\"fa fa-$socicon\"></i></a></li>";
        }
        $out='<ul class="social-icons social-shortcode '.$anim.' '.$class.'">'.implode("\n", $soc_buttons).'</ul>';
		unset($GLOBALS['soc_buttons']);
    }
    return $out;
}

add_shortcode('social', 'alc_social');

/*********************/
function alc_soc_button($atts, $content=NULL){
    extract(shortcode_atts(array(
        'icon'=>'bitbucket',
        'link'=>''
    ), $atts));
    //do_shortcode ($content);
    $x= $GLOBALS['socbuttoncount'];
    $GLOBALS['soc_buttons'][$x]=array('icon'=> $icon, 'link'=>$link);
    $GLOBALS['socbuttoncount']++;

} 

add_shortcode('soc_button', 'alc_soc_button');
/**************************************************/


/***************** TEAM MEMBERS *******************/
function al_teammember($atts, $content=NULL){
    extract(shortcode_atts(array(
		'type'=>'',
        'name'=>'',
        'position'=>'',
		'photo'=>'',
        'anim'=>'',
        'class'=>'',
    ), $atts));
	
	$GLOBALS['sbcount']=0;
	$out='';
	$sizes = '';
	if(function_exists('getimagesize') && !empty($photo)){
		$sizes = getimagesize($photo);
		$sizes = $sizes[3];
	}
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
		do_shortcode ($content);
		if($type=='large' || $type=='small'){
		$out.= '<div class="team '.$type.' '.$anim.' '.$class.'">
					<div class="image">
						<img alt="'.$name.'" src="'.$photo.'" class="img-responsive">
						<div class="overlay">
							<div class="social-icons">';
								if(is_array($GLOBALS['tmsocbuttons'])){
									foreach ($GLOBALS['tmsocbuttons'] as $soc){
										$tmname = ucwords(substr($soc['tmicon'], 3));
										$tmsocbuttons[]='<a href="'.$soc['tmlink'].'"><i class="fa '.$soc['tmicon'].'"></i></a>';
									}	
									$out.=implode("\n", $tmsocbuttons);
								}
						$out.='</div>
						</div>
					</div>
					<div class="content">
						<h6>'.$name.'<span>('.$position.')</span></h6>
						'.do_shortcode($content).'
					</div> <!-- end .content -->
				</div>';
				unset ($GLOBALS['tmsocbuttons']);
		}elseif($type=='alter'){
			$out.='<div class="portfolio-author '.$anim.' '.$class.'">
						<div class="image" style="background-image: url('.$photo.');"></div>
						<div class="content">
							<div class="author-details clearfix">
								<span class="author">'.$name.'</span>
								<span class="title">('.$position.')</span>
							</div>
							<p>'.do_shortcode($content).'</p>
						</div>
					</div>';
		}

		
    return $out;
}

add_shortcode('teammember', 'al_teammember');
/************************/
function al_tmsocbutton($atts, $content=NULL){
    extract(shortcode_atts(array(
        'tmicon'=>'',
        'tmlink'=>''
    ), $atts));
    
	$x = $GLOBALS['sbcount'] ;
    $GLOBALS['tmsocbuttons'][$x]=array('tmicon'=> $tmicon, 'tmlink'=>$tmlink);
    $GLOBALS['sbcount']++;
} 

add_shortcode('tmsocbutton', 'al_tmsocbutton');


/**************************************************/


/********************* List ***********************/

function alc_list( $atts, $content ){
	extract(shortcode_atts(array(
        'anim' => '',
		'type' => 'order',
		'class' => '',
		'color'=>''
					), $atts));
	$GLOBALS['listitem_count'] = 0;
	$counter=0;
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	do_shortcode($content);
	if($type=='order') {
		$tag='<ol ';
		$tagEnd='</ol>';
	}else{
		 $tag='<ul ';
		 $tagEnd='</ul>';
	}
	if( is_array( $GLOBALS['listitems'] ) ){
		foreach( $GLOBALS['listitems'] as $listitem ){
			$listitems[]='<li>';
			if($listitem['link']){$listitems[].='<a href="'.$listitem['link'].'">';}
			if($type=='icon-list'){$listitems[].='<i class="'.$listitem['family'].' '.$listitem['icon'].'"></i>';}
			$listitems[].=do_shortcode($listitem['content']);
			if($listitem['link']){$listitems[].='</a>';}

			$listitems[].='</li>';
			$counter++;
		}
		$return = $tag.' class="'.$anim.' '.$class.' '.$type.' '.$color.' list-shortcode">'.implode( "\n", $listitems ).$tagEnd;
		unset($GLOBALS['listitems']);
	}
	return $return;	
}
add_shortcode('list', 'alc_list');
/************************/
function alc_list_item( $atts, $content = null){
	extract(shortcode_atts(array(
		'title' => '',
		'link' => '',
		'family'=>'fa',
		'icon'=>''
	), $atts));
	
	$x = $GLOBALS['listitem_count'];
	$GLOBALS['listitems'][$x] = array('link'=>$link,  'content'=>$content, 'family'=>$family, 'icon'=>$icon);
	
	$GLOBALS['listitem_count']++;
}
add_shortcode('listitem', 'alc_list_item');

/*********************Blockquote************************/

function alc_blockquote( $atts, $content = null ) {
	extract(shortcode_atts(array( 
		'author'=>'',
		'anim'=>'',
		'class'=>'',
		'company' => '',
		'pos' => '',
		'bcuscolor'=>'',
	), $atts));
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$out='';
	$bcuscolor = (isset($bcuscolor) && !empty($bcuscolor))  ? 'style="border-color:'.$bcuscolor.'"' : '';
		$out.='<blockquote class="'.$pos.' '.$class.''.$anim.'" '.$bcuscolor.'>
			<p>'.do_shortcode($content).'</p>
			<small>'.$author.'<cite title="Source Title"> '.$company.'</cite></small>
		</blockquote>';

		
    return $out;
}
add_shortcode('blockquote', 'alc_blockquote');
/****************** Lightbox ********************/

function alc_lightbox( $atts, $content = null ) {
	extract(shortcode_atts(array( 
		'type'=>'image',
		'thumbnail'=>'',
		'src'=>'',
		'anim'=>'',
		'class'=>'',
	), $atts));
    $out = '';
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$type=($type=='image') ? 'image' : 'iframe';
	$randomID=  mt_rand(0, 10000);
	$imglink='';
	if(function_exists('vc_map')){
		$limage = wp_get_attachment_image_src($thumbnail, 'full');
		$imglink.=$limage[0];
	}else{
		$imglink=$thumbnail;
	}
	$out.='<a href="'.$src.'" class="lightbox-short-'.$randomID.' '.$class.' "    title="'.do_shortcode($content).'"><img src="'.$imglink.'" alt="" class="img-responsive  '.$anim.'"></a>';
    
	$out.='<script type="text/javascript">
		jQuery(document).ready(function(){
			 jQuery(".lightbox-short-'.$randomID.'").magnificPopup({
				type: "'.$type.'",
				tLoading: "Loading source #%curr%...",
				mainClass: "mfp-img-mobile",
			});
		});
	</script>';
	return $out;
}
add_shortcode('lightbox', 'alc_lightbox');
/*****************************************/


/**********************PARALLAX*************************/
function alc_fullbg($atts, $content=NULL){
		extract(shortcode_atts(array(
			'bgcolor'=>'',
			'bgrepeat'=>'no-repeat',
			'bgimage'=>'',
			'class'=>'',
			'padding' => '',
			'custompadding' => '',
			'notopborder' => '',
			'scrollspeed' => '0.6',
			'nobottomborder' => '',
			'videourl' => '',
			'mute' => 'true',
			'autoplay' => 'true',
			'loop' => 'false',
			'showcontrols' => 'true',
			'quality' => 'default',
			"height" => '300',
			'type' => ''
		), $atts));
		$GLOBALS['sbcount']=0;
		
		do_shortcode ($content);
		$randomId = mt_rand(0, 100000);
		$imglink='';
		if(function_exists('vc_map')){
			$limage = wp_get_attachment_image_src($bgimage, 'full');
			$imglink.=$limage[0];
		}else{
			$imglink=$bgimage;
		}
		
		$bgcolor = (isset($bgcolor) && $bgcolor!=='') ? ' background-color:'.$bgcolor.' !important;' : '';
		$bgimage = (isset($bgimage) && $bgimage!=='') ? ' background-image:url('.$imglink.') !important;' : '';
		$bgrepeat = (isset($bgrepeat) && $bgrepeat!=='')? ' background-repeat:'.$bgrepeat.' !important;' : '';
		$height = empty($height) ? '' : 'style="height:'.$height.'px;"';
		
		$elements = $bgcolor.$bgimage.$bgrepeat;
		$custompadding = (isset($custompadding) && !empty($custompadding))  ? ' padding-top:'.$custompadding.'px !Important;  padding-bottom:'.$custompadding.'px !Important' : '';
		$out = '';
		if ($type == 'parallax'){
			$out.= '
			<div class="fullsize parallax-bg '.$notopborder.' '.$nobottomborder.'">
				<div class="parallax-wrapper parallax-background '.$class.'" data-stellar-background-ratio="'.$scrollspeed.'" style="'.$elements.'">
					<div class="parallax-wrapper-inner '.$padding.'"  style="'.$custompadding.'" id="'.$randomId.'">'.do_shortcode($content).'</div>
				</div>
			</div>';
		}
		else{
			$condpad = ($type == 'wvideo') ? '' : $padding;
			$out.= '<div class="fullsize fullsize-background '.$notopborder.' '.$nobottomborder.' '.$condpad.' '.$class.'" style="'.$elements.' '.$custompadding.'">';
				if($type == 'wvideo'){ $out.='<div id="ytwrapper'.$randomId.'" '.$height.'><div id="ytvideo'.$randomId.'" class="player '.$padding.'" style="display:block !important; margin: auto '.$custompadding.'" data-property="{showControls : '.$showcontrols.', videoURL:\''.$videourl.'\', containment:\'#ytwrapper'.$randomId.'\', startAt:0, mute:'.$mute.', autoPlay:'.$autoplay.', loop:'.$loop.', opacity:1,quality:\''.$quality.'\'}">';}
					$out.= do_shortcode($content);
				if($type == 'wvideo') {$out.='</div></div>';}
			$out.='</div>';
			$out.='<script>
			jQuery(function(){
				jQuery("#ytvideo'.$randomId.'").mb_YTPlayer();
			});
			</script>';
		}
		
		return $out;
	}

add_shortcode('fullbg', 'alc_fullbg');

/*********************************************************/

/********************* GOOGLE MAP **********************/


function mapme($attr) {
	wp_enqueue_script('Google-map-api');	
	wp_enqueue_script('Google-map');		
	$number = mt_rand(0, 100000);
	$randomId = "googlemap".$number;
	// default atts
	$attr = shortcode_atts(array(	
		'lat'   => '0', 
		'lon'    => '0',
		'z' => '14',
		'w' => '300',
		'h' => '300',
		'maptype' => 'ROADMAP',
		'address' => '',
		'kml' => '',
		'marker' => '',
		'markerimage' => '',
		'traffic' => 'no',
		'infowindow' => '',
		'class' => ''
		), $attr);
	$imglink='';
	if(function_exists('vc_map')){
		$limage = wp_get_attachment_image_src($attr['markerimage'], 'full');
		$imglink.=$limage[0];
	}else{
		$imglink=$attr['markerimage'];
	}				
	$returnme = '<div class="map-split gm-shortcode '.$attr['class'].'"><div id="' .$randomId . '" style="width:' . $attr['w'] . 'px;height:' . $attr['h'] . 'px;" ></div></div>
  
	<script type="text/javascript">
		jQuery(function () {
    	var latlng = new google.maps.LatLng(' . $attr['lat'] . ', ' . $attr['lon'] . ');
		var myOptions = {
			zoom: ' . $attr['z'] . ',
			center: latlng,
			scrollwheel:false,
			mapTypeId: google.maps.MapTypeId.' . $attr['maptype'] . '
		};
		var ' . $randomId . ' = new google.maps.Map(document.getElementById("' . $randomId . '"),
		myOptions);
		';
				
		//kml
		if($attr['kml'] != '') 
		{
			//Wordpress converts "&" into "&#038;", so converting those back
			$thiskml = str_replace("&#038;","&",$attr['kml']);		
			$returnme .= '
			var kmllayer = new google.maps.KmlLayer(\'' . $thiskml . '\');
			kmllayer.setMap(' . $randomId . ');
			';
		}
		
		//traffic
		if($attr['traffic'] == 'yes')
		{
			$returnme .= '
			var trafficLayer = new google.maps.TrafficLayer();
			trafficLayer.setMap(' . $randomId . ');
			';
		}
	
		//address
		if($attr['address'] != '')
		{
			$returnme .= '
		    var geocoder_' . $randomId . ' = new google.maps.Geocoder();
			var address = \'' . $attr['address'] . '\';
			geocoder_' . $randomId . '.geocode( { \'address\': address}, function(results, status) {
				if (status == google.maps.GeocoderStatus.OK) {
					' . $randomId . '.setCenter(results[0].geometry.location);
					';
					
					if ($attr['marker'] !='')
					{
						//add custom image
						if ($attr['markerimage'] !='')
						{
							$returnme .= 'var image = "'.$imglink .'";';
						}
						$returnme .= '
						var marker = new google.maps.Marker({
							map: ' . $randomId . ', 
							';
							if ($attr['markerimage'] !='')
							{
								$returnme .= 'icon: image,';
							}
						$returnme .= '
							position: ' . $randomId . '.getCenter()
						});
						';

						//infowindow
						if($attr['infowindow'] != '') 
						{
							//first convert and decode html chars
							$thiscontent = htmlspecialchars_decode($attr['infowindow']);
							$returnme .= 'var contentString = \'' . $thiscontent . '\'
								var infowindow = new google.maps.InfoWindow({
								content: contentString
							});
										
							google.maps.event.addListener(marker, \'click\', function() {
							  infowindow.open(' . $randomId . ',marker);
							});
				
							';
						}


					}
			$returnme .= '
				} else {
				alert("Geocode was not successful for the following reason: " + status);
			}
			});
			';
		}

		//marker: show if address is not specified
		if ($attr['marker'] != '' && $attr['address'] == '')
		{
			//add custom image
			if ($attr['markerimage'] !='')
			{
				$returnme .= 'var image = "'. $attr['markerimage'] .'";';
			}

			$returnme .= '
				var marker = new google.maps.Marker({
				map: ' . $arandomId . ', 
				';
				if ($attr['markerimage'] !='')
				{
					$returnme .= 'icon: image,';
				}
			$returnme .= '
				position: ' . $randomId . '.getCenter()
			});
			';

			//infowindow
			if($attr['infowindow'] != '') 
			{
				$returnme .= '
				var contentString = \'' . $attr['infowindow'] . '\';
				var infowindow = new google.maps.InfoWindow({
					content: contentString
				});
							
				google.maps.event.addListener(marker, \'click\', function() {
				  infowindow.open(' . $randomId . ',marker);
				});
	
				';
			}
		}

		$returnme .= '
		});
		</script>';

		return $returnme;
	?>
    

	<?php
}
add_shortcode('map', 'mapme');

/************ Service BLOCK****************/
function alc_sblock($atts, $content=NULL){
    extract(shortcode_atts(array(
        'anim' => '',
		'linkcaption'=>'',
		'link'=>'',
		'title' => '',
		'photo' => '',
		'class' => ''
	), $atts));
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$out='';
	$imglink='';
	if(function_exists('vc_map')){
		$limage = wp_get_attachment_image_src($photo, 'full');
		$imglink.=$limage[0];
	}else{
		$imglink.=$photo;
	}
		$out.='<div class="services-content sblock1 '.$anim.' '.$class.'">
					<img src="'.$imglink.'" alt="img">
					<h3>'.$title.'</h3>					
					<p>'.do_shortcode($content).'</p>
					<a href="'.$link.'">'.$linkcaption.'<i class="fa fa-caret-right"></i></a>
				</div>';

		
    return $out;
}
add_shortcode('sblock', 'alc_sblock');
/*********************Pricing Table***************/
function alc_pricing($atts, $content=NULL){
    extract(shortcode_atts(array(
        'anim' => '',
		'title' => '',
		'currency'=>'',
		'price'=>'',
		'fbutton'=>'',
		'fbutlink'=>'',
		'class'=>''
					), $atts));
	$GLOBALS['column_count'] = 0;
	$counter = 0;
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	do_shortcode($content);
	$out='';
	$out.='<div class="price-shortcode pricing '.$anim.' '.$class.'">
				<div class="row m0 pricingInner">
				<ul class="list-group">
					<li class="list-group-item">
						<h3>'.$title.'</h3>
						<h5>'.$currency.$price.'</h5>
					</li>';
				if( is_array( $GLOBALS['columns'] ) ){
					foreach( $GLOBALS['columns'] as $column ){
						$columns[]='<li class="list-group-item">'.do_shortcode($column['content']).'</li>';
						$counter++;
					}
				$out.=implode( "\n", $columns );
				$out.='<li class="list-group-item">
							<a href="'.$fbutlink.'">'.$fbutton.'</a>
						</li>
					</ul>';
		unset($GLOBALS['columns']);
	}
			$out.='</div>
			</div>';
		
	
	return $out;	
}
add_shortcode('av_pricing', 'alc_pricing');

/************************/
function alc_column( $atts, $content = null){
	extract(shortcode_atts(array(
		'colcontent' => ''
	), $atts));
	
	$x = $GLOBALS['column_count'];
	$GLOBALS['columns'][$x] = array( 'content'=>$content);
	
	$GLOBALS['column_count']++;
	}
add_shortcode('av_column', 'alc_column');
/******************** Divider **********************/
function alc_divider( $atts, $content = null ) {
	extract(shortcode_atts(array( 
		'type'=>'blank-spacer',
		'customsize'=>'',
		'anim'=>'',
		'class'=>''
		), $atts)
	);
	$out = '';
	$anim = empty($anim) ? '' : "animation $anim";
	$customsize = (isset($customsize) && !empty($customsize))  ? ' style="margin-bottom:'.$customsize.'px !important; clear:both;"' : '';
	if ($type=='blank-spacer') {
		$out='<div class="blank-spacer clearfix '.$anim.' '.$class.'" '.$customsize.'></div>';
	}
	elseif($type=='line'){
		$out='<hr class="line-spacer '.$anim.' '.$class.'"/>';
	}
	return $out;
}
add_shortcode('divider', 'alc_divider');

/*********************Single image***************/
function alc_regimage($atts, $content=NULL){
    extract(shortcode_atts(array(
		'image' =>'',
        'anim' => '',
		'imgstyle' => '',
		'alignment'=>'',
		'alt'=>'',
		'link'=>'',
		'class'=>''
	), $atts));

    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$out='';
	$imglink='';
		if(function_exists('vc_map')){
			$limage = wp_get_attachment_image_src($image, 'full');
			$imglink.=$limage[0];
		}else{
			$imglink=$image;
		}

			if($link){
				$out.='<a href="'.$link.'">';
			}
			$out.='<img src="'.$imglink.'" class="img-responsive '.$imgstyle.' '.$alignment.' '.$anim.' '.$class.'" alt="'.$alt.'">';
			if($link){
				$out.='</a>';
			}
		
	return $out;	
}
add_shortcode('regimage', 'alc_regimage');

/*********************Infoblock************************/

function alc_infoblock( $atts, $content = null ) {
	extract(shortcode_atts(array( 
		'anim'=>'',
		'class'=>'',
		'bgcolor'=>'',
		'photo'=>'',
		'title'=>''
	), $atts));
	$anim=(!empty($anim)) ? 'animation '.$anim : '';
	$bgcolor = (isset($bgcolor) && !empty($bgcolor))  ? 'background-color:'.$bgcolor.';' : '';
	$imglink='';
	if(function_exists('vc_map')){
		$limage = wp_get_attachment_image_src($photo, 'full');
		$imglink.=$limage[0];
	}else{
		$imglink=$photo;
	}
	$bgimage = (isset($photo) && !empty($photo))  ? 'background:url('.$imglink.') no-repeat scroll 0 0;' : '';
	$out='<div class=" infoblock '.$class.''.$anim.'" style="'.$bgcolor.' '.$bgimage.'">
			<figure>
				<figcaption>';
				if($title){
					$out.='<h5>'.$title.'</h5>
						<img src="'.get_template_directory_uri().'/images/vision-title.png" alt="">';
				}
				$out.='<p>'.do_shortcode($content).'</p>
				</figcaption>
			</figure>
		</div>';	
    return $out;
}
add_shortcode('infoblock', 'alc_infoblock');



/************ Counter BLOCK****************/
function alc_counter($atts, $content=NULL){
    extract(shortcode_atts(array(
        'anim' => '',
		'title' => '',
		'count' => '',
		'icon' => '',
		'family' => 'fa',
		'color' => '',
		'class' => ''
	), $atts));
	$randomID=  mt_rand(0, 1000);
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$out='';
		$out.='<div  class="fact-box count-short '.$anim.' '.$class.' '.$color.'">
					<i class="'.$family.' '.$icon.'"></i>
					<p>'.$title.'</p>
					<span id="counter-short-'.$randomID.'">'.$count.'</span>
				</div>';
$out.='<script type="text/javascript">
		jQuery(document).ready(function(){
			 jQuery("#counter-short-'.$randomID.'").animateNumber({ number: '.$count.'}, 2000);
		});
	</script>';
		
    return $out;
}
add_shortcode('counter', 'alc_counter');


/**********************Service List*******************/
function alc_servlist($atts, $content=NULL){
    extract(shortcode_atts(array(
        'anim' => '',
		'class' => '',
		'color'=>'',
	), $atts));
	$GLOBALS['servitem_count'] = 0;
	$counter=1;
    $anim=isset($anim) ? 'animation '.$anim : '';
	do_shortcode($content);
	$return='';
		if( is_array( $GLOBALS['servitems'] ) ){
			foreach( $GLOBALS['servitems'] as $servitem ){
			$servitems[]='<div class="col-md-4 features-box">
								<div class="item-icon"><i class="'.$servitem['family'].' '.$servitem['icon'].'"></i><span>'.$counter.'</span></div>
								<div class="features-box-content">
									<h4>'.$servitem['title'].'</h4>
									<p>'.do_shortcode($servitem['content']).'</p>
								</div>
							</div>';
			$counter++;
			}
			$return.= '<div  class="servlist-short features-content row '.$anim.' '.$class.' '.$color.'">'.implode( "\n", $servitems ).'</div>';
			unset($GLOBALS['servitems']);
		}

	
	return $return;	
}

add_shortcode('servlist', 'alc_servlist');
/*******************************************/
 function alc_servitem( $atts, $content = null){
	extract(shortcode_atts(array(
		'title' => '',
		'family' => 'fa',
		'icon'=>''
	), $atts));
	
	$x = $GLOBALS['servitem_count'];
	$GLOBALS['servitems'][$x] = array( 'title'=>$title, 'family'=>$family, 'icon'=>$icon,   'content'=>$content);
	
	$GLOBALS['servitem_count']++;
	}
add_shortcode('servitem', 'alc_servitem');
/*******************************************/
/****** SHOW POST BY ID ********/

function alc_fpost( $atts )
{
	extract( shortcode_atts( array(
		'id' => '',
		'anim'=>'',
		'class'=>'',
	), $atts) );
    $anim=(!empty($anim)) ? 'animation '.$anim : '';
	$return = '';
	$postID=$id;
	$fpost=get_post($postID);
	$return.='<div  class="fpost blog-section '.$class.' '.$anim.'">';
				$showmeta =weblusive_get_option('blog_meta_show') ; 
				$showrmtext = weblusive_get_option('blog_show_rmtext'); 
				$day = get_the_time('d', $fpost->ID);
				$month = get_the_time('M', $fpost->ID);
				$year = get_the_time('Y', $fpost->ID);
				$thumbnail = get_the_post_thumbnail($fpost->ID, 'express-fpost');
				$postmeta = get_post_custom($fpost->ID);
				$return.='<div class="entry-cover">
							<a href="' . get_permalink($fpost->ID) . '">';
								if (!empty($thumbnail)):
									$return.=$thumbnail;
								else:
									$return.='<img src = "http://placehold.it/550x319" alt="'. esc_html__('No image', 'express') . '" />';
								endif;
						$return.='</a>
						</div>
						<div class="enetry-header">
							<div class="entry-title">
								<h3><a href="' . get_permalink($fpost->ID) . '">'.$fpost->post_title.'</a></h3>
							</div>
							<div class="entry-meta">
								<div class="post-date">
									'.$month.' '.$day.', '.$year.'
								</div>
								<div class="byline"> 
									By '.get_the_author().'
								</div>
								<div class="post-comment">
									'.get_comments_number($fpost->ID ).' Comments
								</div>
							</div>
						</div>
						<div class="entry-content">
							<p>'.limit_words($fpost->post_excerpt, 20).'</p>
						</div>
					</div>';

                  
	
	return $return;
}

add_shortcode('fpost', 'alc_fpost');

/************************************************/
/*********************** COLUMNS *************************/

function express_one_whole( $atts, $content = null ) {
	return '<div class="col-md-12">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_whole', 'express_one_whole');

function express_one_half( $atts, $content = null ) {

	return '<div class="col-md-6">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_half', 'express_one_half');


function express_one_third( $atts, $content = null ) {
	return '<div class="col-md-4">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_third', 'express_one_third');


function express_two_third( $atts, $content = null ) {
	return '<div class="col-md-8">' . do_shortcode($content) . '</div>';
}
add_shortcode('two_third', 'express_two_third');


function express_one_fourth( $atts, $content = null ) {

	return '<div class="col-md-3">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_fourth', 'express_one_fourth');

function express_three_fourth( $atts, $content = null ) {
	return '<div class="col-md-9">' . do_shortcode($content) . '</div>';
}
add_shortcode('three_fourth', 'express_three_fourth');

function express_one_sixth( $atts, $content = null ) {
	return '<div class="col-md-2">' . do_shortcode($content) . '</div>';
}
add_shortcode('one_sixth', 'express_one_sixth');

function express_five_twelveth( $atts, $content = null ) {
	return '<div class="col-md-5">' . do_shortcode($content) . '</div>';
}
add_shortcode('five_twelveth', 'express_five_twelveth');

function express_seven_twelveth( $atts, $content = null ) {
	return '<div class="col-md-7">' . do_shortcode($content) . '</div>';
}
add_shortcode('seven_twelveth', 'express_seven_twelveth');

function express_five_sixth( $atts, $content = null ) {
	return '<div class="col-md-10">' . do_shortcode($content) . '</div>';
}
add_shortcode('five_sixth', 'express_five_sixth');

function express_row( $atts, $content = null ) {
	extract(shortcode_atts(array( 
		'custopmargin'=>'',
		'class'=>'',
		'cusbotmargin'=>''
	), $atts));
	$custopmargin=  ($custopmargin) ? 'margin-top:'.$custopmargin.'px;' : '';
	$cusbotmargin=  ($cusbotmargin) ? 'margin-bottom:'.$cusbotmargin.'px;' : '';
   return '<div class="container '.$class.'" style=" '.$cusbotmargin.' '.$custopmargin .'"><div class="row">' . do_shortcode($content) . '</div></div>';
}
add_shortcode('row', 'express_row');

function express_inner_row( $atts, $content = null ) {
	extract(shortcode_atts(array( 
		'custopmargin'=>'',
		'class'=>'',
		'cusbotmargin'=>''
	), $atts));
	$custopmargin=  ($custopmargin) ? 'margin-top:'.$custopmargin.'px;' : '';
	$cusbotmargin=  ($cusbotmargin) ? 'margin-bottom:'.$cusbotmargin.'px;' : '';
   return '<div class="row '.$class.'" style=" '.$cusbotmargin.' '.$custopmargin .'">' . do_shortcode($content) . '</div>';
}
add_shortcode('inner_row', 'express_inner_row');
/************************************************/


/******************** CLEAR *********************/

function alc_clear($atts, $content = null) {	
	return '<div class="clearfix"></div>';
}
add_shortcode('clear', 'alc_clear');


/******** SHORTCODE SUPPORT FOR WIDGETS *********/

if (function_exists ('shortcode_unautop')) {
	add_filter ('widget_text', 'shortcode_unautop');
}
add_filter ('widget_text', 'do_shortcode');

/************************************************/
?>