<?php get_header();
$bgimage=weblusive_get_option('innerheading_background_image');
if($bgimage) {
	$bgimg=$bgimage;
}else{
	$bgimg=get_template_directory_uri() .'/images/error-banner.jpg' ;
}
?>
<?php if(!((weblusive_get_option('hide_titles') && weblusive_get_option('hide_breadcrumbs')))):?>
<div id="page-banner" class="page-banner container-fluid no-padding" style="background: url(<?php echo esc_url($bgimg);?>) no-repeat center center / cover #000000;">
	<div class="banner-content">
		<?php if (!weblusive_get_option('hide_titles')):?>
			<h3><?php esc_html_e('Page Not Found', 'express')?></h3>
		<?php endif; ?>
		<?php if (!weblusive_get_option('hide_breadcrumbs')):?>
			<?php if(class_exists('the_breadcrumb')){ $albc = new the_breadcrumb; } ?>
		<?php endif; ?>
	</div>
</div>
<?php endif; ?>
<div class="error-page container-fluid no-padding">
	<div class="section-padding"></div>
	<div class="error-code">
		<h3><?php esc_html_e('404', 'express')?></h3>
	</div>
	<img src="<?php echo get_template_directory_uri() .'/images/error.jpg';?>" alt="errorpage">
	<div class="section-padding"></div>
	<?php if(weblusive_get_option( 'err404_title' )):?>
		<h3><?php echo weblusive_get_option( 'err404_title' ) ?></h3>
	<?php endif?>
	<div class="section-padding"></div>
	<div class="col-md-6 col-sm-6">
		<form action="<?php echo esc_url( home_url('/') ); ?>" method="get" id="search-bar" class="search-form">
			<div class="input-group">
				<input type="search" class="form-control" placeholder="<?php esc_html_e('Enter your search queries', 'express');?>"  name="s" id="search" value="<?php the_search_query(); ?>">
				<span class="input-group-btn">
					<button class="btn btn-default-2" type="submit">Serch</button>
				</span>
			</div>
		</form>
		<div class="error-page-content">
			<?php if(weblusive_get_option( 'err404_content' )):?>
				<?php echo htmlspecialchars_decode(do_shortcode(weblusive_get_option( 'err404_content' ))); ?>
			<?php endif?>
			<div class="section-padding"></div>
			<a href="<?php echo esc_url(home_url('/'));?>"><?php esc_html_e('Back To Home', 'express')?></a>
			<div class="section-padding"></div>
		</div>
	</div>
</div>
<?php get_footer(); ?>
