 

<!-- JS (bundle inclui Popper) -->
<script
  src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js"
  integrity="sha384-ndDqU0Gzau9qJ1lfW4pNLlhNTkCfHzAVBReH9diLvGRem5+R9g2FzA8ZGN954O5Q"
  crossorigin="anonymous"></script>

<?php
/**
 * Minha Conta � Pedidos � Controle Financeiro
 * (COM CANCELAMENTO + DATA DE VIAGEM via _wbtm_bp_time/_wbtm_ticket_info[].date)
 */
defined('ABSPATH') || exit;

/* =========================================================
 * Helpers de meta e Data de Viagem
 * ========================================================= */

/** Primeiro meta n�o vazio entre ITEM e PEDIDO, respeitando a ordem de $keys */
function meta_first_item_order($item, WC_Order $order, array $keys): string {
    foreach ($keys as $k) {
        if (!$k) continue;
        $v = is_object($item) ? trim((string)$item->get_meta($k)) : '';
        if ($v !== '') return $v;
        $v = trim((string)$order->get_meta($k));
        if ($v !== '') return $v;
    }
    return '';
}

/** Normaliza string data/hora (suporta 10/08/2025 14:30 etc.) ? timestamp */
function _wbtm_try_parse_ts($raw){
    if (!$raw) return null;
    $raw = preg_replace('/\s+/', ' ', (string)$raw);
    $raw = str_replace('/', '-', $raw);
    $ts  = strtotime($raw);
    return $ts ?: null;
}

/**
 * Descobre data/hora de VIAGEM/EMBARQUE:
 * 1) _wbtm_bp_time (item/pedido)
 * 2) _wbtm_ticket_info[].date  (1� v�lida)
 * 3) pares comuns _wbtm_date/_wbtm_time, journey_*, travel_*...
 * Retorna: [ts|null, 'Y-m-d', 'd/m/Y[ H:i]', 'H:i'].
 */
function wbtm_get_travel_dt(WC_Order $order): array {
    $item = $order ? reset($order->get_items()) : null;
    if (!$item) return [null, '', '', ''];

    /* 1) prioridade: _wbtm_bp_time */
    $bp_time = meta_first_item_order($item, $order, ['_wbtm_bp_time']);
    if ($bp_time && ($ts = _wbtm_try_parse_ts($bp_time))) {
        $iso   = date('Y-m-d', $ts);
        $hora  = date('H:i', $ts);
        $label = date_i18n('d/m/Y', $ts) . ($hora !== '00:00' ? ' '.$hora : '');
        return [$ts, $iso, $label, $hora];
    }

    /* 2) fallback: _wbtm_ticket_info[].date (pega a 1� v�lida) */
    $ti = $item->get_meta('_wbtm_ticket_info');
    if (is_array($ti) && $ti) {
        foreach ($ti as $row) {
            $d = isset($row['date']) ? trim((string)$row['date']) : '';
            if (!$d) continue;
            if ($ts = _wbtm_try_parse_ts($d)) {
                $iso   = date('Y-m-d', $ts);
                $hora  = '00:00';
                $label = date_i18n('d/m/Y', $ts);
                return [$ts, $iso, $label, $hora];
            }
        }
    }

    /* 3) pares comuns (data+hora) ou datetime �nicos */
    $date_keys = [
        '_wbtm_date','_wbtm_journey_date','wbtm_travel_date','journey_date','travel_date',
        'data_viagem','data_da_viagem','data_de_viagem','data_do_embarque','data_embarque',
        'data_partida','data_saida','_wbtm_jdate','_wbtm_date_only','date_of_journey','doj',
        'embarque_date','embarque_data','Data de Viagem','Data do Embarque'
    ];
    $time_keys = [
        '_wbtm_time','_wbtm_journey_time','wbtm_travel_time','journey_time','travel_time',
        'hora_viagem','hora_da_viagem','hora_de_viagem','hora_do_embarque','hora_embarque',
        'hora_partida','hora_saida','_wbtm_jtime','_wbtm_time_only','time_of_journey','toj',
        'embarque_time','embarque_hora','Hora de Viagem','Hora do Embarque'
    ];
    $datetime_keys = [
        '_wbtm_datetime','travel_datetime','journey_datetime',
        'datetime_viagem','embarque_datetime','DataHora da Viagem'
    ];

    foreach ($date_keys as $dk) {
        $d = meta_first_item_order($item, $order, [$dk]);
        if ($d === '') continue;

        // tenta combinar com hora
        foreach ($time_keys as $tk) {
            $t = meta_first_item_order($item, $order, [$tk]);
            $raw = trim($d.' '.$t);
            if (!$raw) continue;
            if ($ts = _wbtm_try_parse_ts($raw)) {
                $iso   = date('Y-m-d', $ts);
                $hora  = date('H:i', $ts);
                $label = date_i18n('d/m/Y', $ts) . ($hora !== '00:00' ? ' '.$hora : '');
                return [$ts, $iso, $label, $hora];
            }
        }
        // s� data
        if ($ts = _wbtm_try_parse_ts($d)) {
            $iso   = date('Y-m-d', $ts);
            $hora  = '00:00';
            $label = date_i18n('d/m/Y', $ts);
            return [$ts, $iso, $label, $hora];
        }
    }

    // datetime �nicos
    foreach ($datetime_keys as $kk) {
        $raw = meta_first_item_order($item, $order, [$kk]);
        if ($ts = _wbtm_try_parse_ts($raw)) {
            $iso   = date('Y-m-d', $ts);
            $hora  = date('H:i', $ts);
            $label = date_i18n('d/m/Y', $ts) . ($hora !== '00:00' ? ' '.$hora : '');
            return [$ts, $iso, $label, $hora];
        }
    }

    return [null, '', '', ''];
}

/* =========================================================
 * 1) Endpoints AJAX (acerto/cancelamento)
 * ========================================================= */
if (isset($_REQUEST['financeiro_api']) && $_REQUEST['financeiro_api'] == '1') {
    nocache_headers();
    if (!is_user_logged_in()) wp_send_json_error(['msg'=>'Login necess�rio'],401);
    if (!current_user_can('administrator')) wp_send_json_error(['msg'=>'Sem permiss�o para alterar o status financeiro'],403);

    $nonce = $_REQUEST['nonce'] ?? '';
    if (!wp_verify_nonce($nonce, 'set_status_financeiro')) wp_send_json_error(['msg'=>'Nonce inv�lido/expirado'],403);

    $order_id = absint($_REQUEST['order_id'] ?? 0);
    $status   = sanitize_text_field($_REQUEST['status'] ?? '');
    if (!$order_id || !in_array($status, ['pago','nao-pago'], true)) wp_send_json_error(['msg'=>'Par�metros inv�lidos'],400);

    $order = wc_get_order($order_id);
    if (!$order) wp_send_json_error(['msg'=>'Pedido n�o encontrado'],404);
    if ($order->has_status('cancelled')) wp_send_json_error(['msg'=>'Pedido cancelado n�o pode alterar acerto'],409);

    $order->update_meta_data('_financeiro_status', $status);
    $order->save();
    wp_send_json_success(['ok'=>true,'order_id'=>$order_id,'status'=>$status]); exit;
}

if (isset($_REQUEST['order_api']) && $_REQUEST['order_api'] == '1') {
    nocache_headers();
    if (!is_user_logged_in()) wp_send_json_error(['msg'=>'Login necess�rio'],401);
    if (!current_user_can('administrator')) wp_send_json_error(['msg'=>'Sem permiss�o'],403);

    $nonce = $_REQUEST['nonce'] ?? '';
    if (!wp_verify_nonce($nonce, 'order_actions_nonce')) wp_send_json_error(['msg'=>'Nonce inv�lido/expirado'],403);

    $order_id = absint($_REQUEST['order_id'] ?? 0);
    $action   = sanitize_text_field($_REQUEST['action'] ?? '');
    if (!$order_id || $action !== 'cancel') wp_send_json_error(['msg'=>'Par�metros inv�lidos'],400);

    $order = wc_get_order($order_id);
    if (!$order) wp_send_json_error(['msg'=>'Pedido n�o encontrado'],404);

    if ($order->has_status('cancelled')) wp_send_json_success(['ok'=>true,'order_id'=>$order_id,'status'=>'cancelled']);

    $order->update_status('cancelled', 'Cancelado pelo painel Financeiro (Minha Conta � Pedidos).');
    wp_send_json_success(['ok'=>true,'order_id'=>$order_id,'status'=>'cancelled']); exit;
}

/* =========================================================
 * 2) Flags / Nonce / Datas default
 * ========================================================= */
$is_admin   = current_user_can('administrator');
$is_author  = current_user_can('author');

$nonce_fin  = wp_create_nonce('set_status_financeiro');
$orders_url = wc_get_endpoint_url('orders', '', wc_get_page_permalink('myaccount'));
$endpoint_url        = esc_url(add_query_arg('financeiro_api', '1', $orders_url));
$order_actions_nonce = wp_create_nonce('order_actions_nonce');
$order_endpoint_url  = esc_url(add_query_arg('order_api', '1', $orders_url));

$now_ts     = current_time('timestamp');
$default_to = date('Y-m-d', $now_ts);
$default_fr = date('Y-m-d', $now_ts - 29 * DAY_IN_SECONDS);

echo '<script>'
   .'window.FIN_NONCE="'.esc_js($nonce_fin).'";'
   .'window.FIN_URL="'.esc_js($endpoint_url).'";'
   .'window.ORDER_NONCE="'.esc_js($order_actions_nonce).'";'
   .'window.ORDER_URL="'.esc_js($order_endpoint_url).'";'
   .'window.DEFAULT_FROM="'.esc_js($default_fr).'";'
   .'window.DEFAULT_TO="'.esc_js($default_to).'";'
   .'</script>';

/* =========================================================
 * 3) Coleta de pedidos conforme permiss�o
 * ========================================================= */
$orders_list = [];
if ($is_admin || $is_author) {
    $all_ids = wc_get_orders([
        'status'  => array_keys(wc_get_order_statuses()),
        'limit'   => -1,
        'orderby' => 'date',
        'order'   => 'DESC',
        'return'  => 'ids',
    ]);
    $uid = get_current_user_id();
    foreach ($all_ids as $oid) {
        if ($is_author && !$is_admin) {
            if ((int)get_post_field('post_author', $oid) !== $uid) continue;
        }
        $orders_list[] = wc_get_order($oid);
    }
} else {
    if (!empty($customer_orders->orders ?? [])) {
        foreach ($customer_orders->orders as $co) $orders_list[] = wc_get_order($co);
    }
}
$has_orders = !empty($orders_list);

/* =========================================================
 * 4) Cabe�alho Woo padr�o
 * ========================================================= */
do_action('woocommerce_before_account_orders', $has_orders);

/* =========================================================
 * 5) UI + Tabela
 * ========================================================= */
if ($has_orders) :

    // Combos de filtro
    $transportes = $embarques = $desembarques = $pagamentos = $operadores = [];
    $status_opts = [];
    $datas_viagem = []; // Y-m-d �nicas

    foreach ($orders_list as $o) {
        if (!$o) continue;

        $it    = reset($o->get_items());
        $trans = $it ? $it->get_name() : '';

        // Embarque/Destino alinhado ao seu comprovante
        $orig  = meta_first_item_order($it, $o, ['Embarque', '_wbtm_bp']);
        $dest  = meta_first_item_order($it, $o, ['Deixando cair', 'Destino', '_wbtm_dp']);

        $met   = $o->get_payment_method_title();

        $author_id = (int) get_post_field('post_author', $o->get_id());
        $oper      = $author_id ? get_the_author_meta('display_name', $author_id) : '�';

        $st_slug   = $o->get_status();
        $st_label  = wc_get_order_status_name($st_slug);

        if ($trans && !in_array($trans, $transportes, true))   $transportes[] = $trans;
        if ($orig  && !in_array($orig,  $embarques,   true))   $embarques[]   = $orig;
        if ($dest  && !in_array($dest,  $desembarques,true))   $desembarques[]= $dest;
        if ($met   && !in_array($met,   $pagamentos,  true))   $pagamentos[]  = $met;
        if ($is_admin && $oper && !in_array($oper, $operadores, true)) $operadores[] = $oper;
        if ($st_slug && empty($status_opts[$st_slug])) $status_opts[$st_slug] = $st_label;

        // Data Viagem (para popular select)
        list($viagem_ts_loop, $viagem_iso_loop) = wbtm_get_travel_dt($o);
        if ($viagem_iso_loop && !in_array($viagem_iso_loop, $datas_viagem, true)) $datas_viagem[] = $viagem_iso_loop;
    }
    sort($transportes); sort($embarques); sort($desembarques); sort($pagamentos); sort($operadores);
    asort($status_opts);
    sort($datas_viagem);
    ?>


<main id="main" class="site-main">
<h6 class="text-secondary mb-1">
  Ol&aacute; - <?php echo esc_html( wp_get_current_user()->display_name ); ?>
</h6>

  <!-- Cards Totais -->
  <div class="cards">
    <div class="card aberto"><div class="t">Em aberto</div><div class="v" id="total-aberto">R$ 0,00</div></div>
    <div class="card pago"><div class="t">Pago</div><div class="v" id="total-pago">R$ 0,00</div></div>
    <div class="card vendas"><div class="t">Total de Vendas (filtrado)</div><div class="v" id="total-vendas">R$ 0,00</div></div>
    <div class="card cancelado"><div class="t">Cancelados (filtrado)</div><div class="v" id="total-cancelado">R$ 0,00</div></div>
  </div>

  <!-- Toggle Filtros (mobile) -->
  <button class="btn-filtros-toggle" aria-expanded="false" aria-controls="filtros">Mostrar filtros</button>

  <!-- Filtros -->
  <div id="filtros" class="filtros" data-collapsible>
    <div><label>Data inicial</label><input type="date" id="fDataIni" value="<?php echo esc_attr($default_fr); ?>"></div>
    <div><label>Data final</label><input type="date" id="fDataFim" value="<?php echo esc_attr($default_to); ?>"></div>

    <div><label>Data de viagem</label>
      <select id="fDataV">
        <option value="">Todas</option>
        <?php foreach ($datas_viagem as $dv) {
          echo '<option value="'.esc_attr($dv).'">'.esc_html( date_i18n('d/m/Y', strtotime($dv)) ).'</option>';
        } ?>
      </select>
    </div>

    <?php if ($is_admin): ?>
    <div><label>Operador</label>
      <select id="fOp"><option value="">Todos</option><?php foreach ($operadores as $op) echo '<option>' . esc_html($op) . '</option>'; ?></select>
    </div>
    <?php endif; ?>

    <div><label>Transporte</label>
      <select id="fTrans"><option value="">Todos</option><?php foreach ($transportes as $t) echo '<option>' . esc_html($t) . '</option>'; ?></select>
    </div>
    <div style="display:none;"><label>Embarque</label>
      <select id="fEmb"><option value="">Todos</option><?php foreach ($embarques as $e) echo '<option>' . esc_html($e) . '</option>'; ?></select>
    </div>
    <div><label>Desembarque</label>
      <select id="fDes"><option value="">Todos</option><?php foreach ($desembarques as $d) echo '<option>' . esc_html($d) . '</option>'; ?></select>
    </div>
    <div><label>Pagamento</label>
      <select id="fMet"><option value="">Todos</option><?php foreach ($pagamentos as $p) echo '<option>' . esc_html($p) . '</option>'; ?></select>
    </div>
    <div><label>Acertos</label>
      <select id="fFin">
        <option value="">Todos</option>
        <option value="pago">Pago</option>
        <option value="nao-pago">Pendente</option>
      </select>
    </div>
    <div style="display:none;" ><label>Status pedido</label>
      <select id="fStat">
        <option value="">Todos</option>
        <?php foreach ($status_opts as $slug => $label) echo '<option value="'.esc_attr($slug).'">'.esc_html($label).'</option>'; ?>
      </select>
    </div>
    <div style="align-self:end"><button id="limpar" class="button limpar">Limpar</button></div>
  </div>

  <!-- A��es em lote (ADMIN) -->
  <?php if ($is_admin): ?>
  <div class="lote">
    <button id="lote-pago"  class="button">Marcar como Pago</button>
    <button id="lote-npago" class="button">Marcar como Pendente</button>
    <span id="lote-ind" style="display:none;margin-left:8px">Salvando�</span>
  </div>
  <?php endif; ?>

  <!-- Tabela -->
  <table id="tb" class="display nowrap" style="width:100%">
    <thead>
      <tr>
        <th></th> <!-- controle responsive -->
        <?php if ($is_admin): ?><th></th><?php endif; ?> <!-- select-checkbox (s� admin) -->
        <th>Pedido</th>
        <th>Data</th>
        <th>Data Viagem</th>
        <th>Operador</th>
        <th>Transporte</th>
        <th>Embarque</th>
        <th>Desembarque</th>
        <th>Total</th>
        <th>Pagamento</th>
        <th>Status</th>
        <th>Acerto</th>
        <th>A&ccedil;&otilde;es</th>
      </tr>
    </thead>
    <tbody>
      <?php
      foreach ($orders_list as $o) {
        if (!$o) continue;

        $id   = $o->get_id();
        $url  = esc_url($o->get_view_order_url());
        $num  = esc_html($o->get_order_number());
        $dt   = $o->get_date_created();
        $date_iso = $dt ? $dt->date('Y-m-d') : '';
        $data = $dt ? date_i18n('d/m/Y', $dt->getTimestamp()) : '';

        // Data Viagem (embarque)
        list($viagem_ts, $viagem_iso, $viagem_label, $viagem_hora) = wbtm_get_travel_dt($o);
        $ordKey = $viagem_iso . ($viagem_hora ? ' '.$viagem_hora : '');

        $author_id = (int) get_post_field('post_author', $id);
        $operador  = $author_id ? get_the_author_meta('display_name', $author_id) : '�';

        $met    = $o->get_payment_method_title();
        $it     = reset($o->get_items());
        $trans  = $it ? $it->get_name() : '-';

        // Embarque/Destino no mesmo padr�o do seu comprovante
        $orig   = meta_first_item_order($it, $o, ['Embarque', '_wbtm_bp']);
        $dest   = meta_first_item_order($it, $o, ['Deixando cair', 'Destino', '_wbtm_dp']);

        $tot   = (float) $o->get_total();

        $fin      = $o->get_meta('_financeiro_status') ?: 'nao-pago';
        $is_pago  = ($fin === 'pago');

        $ost        = $o->get_status();
        $ost_label  = wc_get_order_status_name($ost);
        $is_cancel  = ($ost === 'cancelled');

        $rot_text = $is_pago ? 'Pago' : 'Pendente';
        $color_bg = $is_pago ? '#28a745' : '#dc3545';
        $row_class = trim(($is_pago ? '' : 'npago') . ' ' . ($is_cancel ? 'cancelado' : ''));

        // --- ACERTO (coluna) ---
        if ($is_cancel) {
            $fin_html = '<span class="badge rounded-pill badge-cancelado">Cancelado</span>';
        } elseif ($is_admin) {
            $fin_html = sprintf(
                '<button type="button"
                    class="btn fin-badge rounded-pill px-2 py-0"
                    style="background-color:%s !important;color:#fff !important;border:none !important;"
                    data-order-id="%d"
                    data-next="%s"
                    aria-label="Alternar status financeiro">%s</button>',
                esc_attr($color_bg),
                (int) $id,
                esc_attr($is_pago ? 'nao-pago' : 'pago'),
                esc_html($rot_text)
            );
        } else {
            $fin_html = sprintf(
                '<span class="badge rounded-pill"
                    style="background-color:%s !important;color:#fff !important;">%s</span>',
                esc_attr($color_bg),
                esc_html($rot_text)
            );
        }

        // A��es
        if ($is_admin && !$is_cancel) {
            $acoes = '<button type="button" class="btn btn-sm btn-outline-danger btn-cancelar" data-order-id="'.(int)$id.'">Cancelar</button>';
        } else {
            $acoes = $is_cancel ? 'Cancelado' : '�';
        }

        echo '<tr class="' . esc_attr($row_class) . '"'
           . ' data-id="' . esc_attr($id) . '"'
           . ' data-fin="' . esc_attr($fin) . '"'
           . ' data-total="' . esc_attr($tot) . '"'
           . ' data-date="' . esc_attr($date_iso) . '"'
           . ' data-tripdate="' . esc_attr($viagem_iso) . '"'
           . ' data-status="' . esc_attr($ost) . '">';

        echo '<td></td>';
        if ($is_admin) echo '<td></td>';
        echo '<td><a href="' . $url . '">#' . $num . '</a></td>';
        echo '<td>' . esc_html($data) . '</td>';
        echo '<td data-order="' . esc_attr($ordKey) . '">' . ($viagem_label ? esc_html($viagem_label) : '�') . '</td>';
        echo '<td>' . esc_html($operador) . '</td>';
        echo '<td>' . esc_html($trans) . '</td>';
        echo '<td>' . esc_html($orig) . '</td>';
        echo '<td>' . esc_html($dest) . '</td>';
        echo '<td>R$ ' . number_format($tot, 2, ',', '.') . '</td>';
        echo '<td>' . esc_html($met) . '</td>';
        echo '<td class="td-status">' . esc_html($ost_label) . '</td>';
        echo '<td>' . $fin_html . '</td>';
        echo '<td>' . $acoes . '</td>';
        echo '</tr>';
      }
      ?>
    </tbody>
  </table>

  <!-- CSS / Libs -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.7.0/css/select.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">
  <style>
    :root{ --cancelado:#6c757d; }

    .cards{ display:grid; grid-template-columns:repeat(4,minmax(220px,1fr)); gap:12px; margin:10px 0 14px }
    .card{padding:16px;border-radius:10px;color:#fff}
    .card .t{opacity:.85;font-size:13px}
    .card .v{font-size:22px;font-weight:700;margin-top:4px}
    .card.aberto{background:#dc3545}
    .card.pago{background:#28a745}
    .card.vendas{background:#1e88e5}
    .card.cancelado{background:var(--cancelado)}

    .btn-filtros-toggle{ display:none; margin:4px 0 8px; padding:10px 12px; border-radius:8px; border:1px solid #ddd; background:#f7f7f7; font-weight:600; width:100%; text-align:center }
    .filtros{ display:grid; grid-template-columns:repeat(9,1fr); gap:8px; margin:8px 0 12px }
    .filtros label{display:block;font-size:12px;margin-bottom:2px}
    .filtros input,.filtros select{padding:8px;border:1px solid #ddd;border-radius:8px;width:100%}
    .button.limpar{background:#ffb300;border:none;font-weight:600;padding:8px 12px;border-radius:8px}

    .lote{margin:6px 0 12px}

    .badge{padding:.2rem .5rem;border-radius:6px;color:#fff;display:inline-block;font-weight:600}
    .badge.disabled{opacity:.7; filter:grayscale(0.2)}
    .badge-cancelado{ background:var(--cancelado) !important; color:#fff !important; }

    tr.npago td{background:#fff8f8}
    tr.cancelado td{background:#f2f2f2 !important; color:#6c757d}
    tr.cancelado a{color:#6c757d; text-decoration:line-through}
    button.fin-badge:disabled{opacity:.65; cursor:not-allowed}

    .dt-buttons{display:flex;flex-wrap:wrap;gap:8px}
    button.fin-badge{ border:0; background:transparent; cursor:pointer; font:inherit; line-height:inherit; padding:0; }

    @media (max-width: 1180px){
      .cards{grid-template-columns:repeat(2,minmax(0,1fr))}
      .btn-filtros-toggle{display:block}
      .filtros[data-collapsible]{display:none}
      .filtros[data-open="1"]{display:grid}
      .filtros{grid-template-columns:repeat(2,1fr)}
    }
    @media (max-width: 640px){
      .cards{grid-template-columns:1fr}
    }
  </style>

  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
  <script src="https://cdn.datatables.net/select/1.7.0/js/dataTables.select.min.js"></script>
  <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>

  <script>
  jQuery(function($){
    const IS_ADMIN = <?php echo $is_admin ? 'true' : 'false'; ?>;
    const BRL = v => (Number(v)||0).toLocaleString('pt-BR',{style:'currency',currency:'BRL'});

    // �ndices (com Data de Viagem DTV)
    const IDX = IS_ADMIN
      ? {CTL:0,SEL:1,PED:2,DT:3,DTV:4,OP:5,TR:6,EMB:7,DES:8,TOT:9,MET:10,STAT:11,FIN:12,ACOES:13}
      : {CTL:0,PED:1,DT:2,DTV:3,OP:4,TR:5,EMB:6,DES:7,TOT:8,MET:9,STAT:10,FIN:11,ACOES:12};

    const $btnFiltros = $('.btn-filtros-toggle');
    const $filtros = $('#filtros');
    $btnFiltros.on('click', function(){
      const open = $filtros.attr('data-open') === '1' ? '0' : '1';
      $filtros.attr('data-open', open);
      this.setAttribute('aria-expanded', open==='1' ? 'true' : 'false');
      this.textContent = open==='1' ? 'Ocultar filtros' : 'Mostrar filtros';
    });

    const opts = {
      responsive: { details: { type:'column', target: 0 } },
      dom:'Bfrtip',
      order:[[ IDX.DT, 'desc' ]],
      language:{ url:'//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' },
      buttons: IS_ADMIN ? [
        { text:'Selecionar (filtrados)', action:(e,dt)=> dt.rows({search:'applied'}).select() },
        { text:'Limpar sele&ccedil;&atilde;o',         action:(e,dt)=> dt.rows().deselect() },
        { extend:'copy',  text:'Copiar'  },
        { extend:'excel', text:'Excel'   },
        { extend:'print', text:'Imprimir'}
      ] : [
        { extend:'copy',  text:'Copiar'  },
        { extend:'excel', text:'Excel'   },
        { extend:'print', text:'Imprimir'}
      ],
      columnDefs: [
        {targets: 0, className:'control', orderable:false, searchable:false},
        {targets: IDX.TOT, className:'dt-right'},
        {targets: [IDX.PED, IDX.DT, IDX.DTV, IDX.TOT, IDX.FIN], responsivePriority: 1},
        {targets: [IDX.OP, IDX.STAT, IDX.ACOES], responsivePriority: 2},
        {targets: '_all', responsivePriority: 100}
      ]
    };
    if (IS_ADMIN){
      opts.select = { style:'multi', selector:'td.select-checkbox' };
      opts.columnDefs.splice(1, 0, {targets:IDX.SEL, className:'select-checkbox', orderable:false, searchable:false});
    }
    const tb = $('#tb').DataTable(opts);
    if(!IS_ADMIN){ tb.column(1).visible(false); }

    function atualizarTotais(){
      let pago=0, aberto=0, vendas=0, cancelado=0;
      tb.rows({search:'applied'}).every(function(){
        const tr = this.node();
        const v  = parseFloat(tr.dataset.total||'0')||0;
        const stPedido = (tr.dataset.status||'').toLowerCase();
        const stFin    = tr.dataset.fin || 'nao-pago';
        if (stPedido === 'cancelled') {
          cancelado += v;
        } else {
          vendas += v;
          if (stFin==='pago') pago+=v; else aberto+=v;
        }
      });
      $('#total-pago').text(BRL(pago));
      $('#total-aberto').text(BRL(aberto));
      $('#total-vendas').text(BRL(vendas));
      $('#total-cancelado').text(BRL(cancelado));
    }

    // Filtros custom
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex){
      if(settings.nTable.id!=='tb') return true;
      const tr   = tb.row(dataIndex).node();

      // Data do pedido
      const dIso = tr.dataset.date || '';
      const di = $('#fDataIni').val() || '';
      const df = $('#fDataFim').val() || '';
      if(di && dIso < di) return false;
      if(df && dIso > df) return false;

      // Data de Viagem
      const fDV = $('#fDataV').val() || '';
      const tripIso = tr.dataset.tripdate || '';
      if (fDV && tripIso !== fDV) return false;

      const fOp = $('#fOp').val()   || '';
      const fT  = $('#fTrans').val()|| '';
      const fE  = $('#fEmb').val()  || '';
      const fD  = $('#fDes').val()  || '';
      const fM  = $('#fMet').val()  || '';
      const fF  = $('#fFin').val()  || '';
      const fS  = ($('#fStat').val()||'').toLowerCase();

      const iOP = IDX.OP, iTR = IDX.TR, iEM = IDX.EMB, iDE = IDX.DES, iME = IDX.MET;
      if(fOp && (data[iOP]||'') !== fOp) return false;
      if(fT  && (data[iTR]||'') !== fT)  return false;
      if(fE  && (data[iEM]||'') !== fE)  return false;
      if(fD  && (data[iDE]||'') !== fD)  return false;
      if(fM  && (data[iME]||'') !== fM)  return false;

      if(fF && (tr.dataset.fin||'') !== fF) return false;
      if(fS && (tr.dataset.status||'').toLowerCase() !== fS) return false;
      return true;
    });

    function aplicarFiltroInicial(){
      if(!$('#fDataIni').val()) $('#fDataIni').val(window.DEFAULT_FROM || '');
      if(!$('#fDataFim').val()) $('#fDataFim').val(window.DEFAULT_TO   || '');
      tb.draw(); atualizarTotais();
    }

    $('#fDataIni,#fDataFim,#fDataV,#fOp,#fTrans,#fEmb,#fDes,#fMet,#fFin,#fStat').on('change', ()=> { tb.draw(); atualizarTotais(); });
    $('#limpar').on('click', function(){
      $('#fDataIni').val(window.DEFAULT_FROM || '');
      $('#fDataFim').val(window.DEFAULT_TO   || '');
      $('#fDataV').val('');
      $('#fOp,#fTrans,#fEmb,#fDes,#fMet,#fFin,#fStat').val('');
      tb.search('').columns().search('');
      tb.draw(); atualizarTotais();
    });

    aplicarFiltroInicial();

    // ===== AJAX helpers =====
    function salvarAcerto(orderId, status){
      return $.ajax({
        url: window.FIN_URL,
        method: 'POST',
        dataType: 'json',
        data: { nonce: window.FIN_NONCE, order_id: orderId, status: status, financeiro_api: 1 }
      });
    }
    function cancelarPedido(orderId){
      return $.ajax({
        url: window.ORDER_URL,
        method: 'POST',
        dataType: 'json',
        data: { nonce: window.ORDER_NONCE, order_id: orderId, action: 'cancel', order_api: 1 }
      });
    }

    function aplicarUIAcerto($tr, novoStatus){
      $tr.attr('data-fin', novoStatus);
      if(novoStatus === 'pago') $tr.removeClass('npago'); else $tr.addClass('npago');
      const $badge = $tr.find('.fin-badge, .badge');
      const ehPago = (novoStatus === 'pago');
      const novaCor = ehPago ? '#28a745' : '#dc3545';
      $badge.text(ehPago ? 'Pago' : 'Pendente')
            .css({'background-color': novaCor, 'color':'#fff', 'border':'none'});
      if ($badge.hasClass('fin-badge')) $badge.attr('data-next', ehPago ? 'nao-pago' : 'pago');
    }

    function aplicarUICancelado($tr){
      $tr.addClass('cancelado').attr('data-status','cancelled');
      $tr.find('.td-status').text('Cancelado');

      // Coluna ACERTO -> cinza + "Cancelado" (mesma cor do card.cancelado)
      const $btn = $tr.find('.fin-badge'); // bot�o (admin)
      if ($btn.length){
        $btn.replaceWith('<span class="badge rounded-pill badge-cancelado">Cancelado</span>');
      } else {
        const $badge = $tr.find('td').eq(IDX.FIN).find('.badge');
        if ($badge.length){
          $badge.replaceWith('<span class="badge rounded-pill badge-cancelado">Cancelado</span>');
        } else {
          $tr.find('td').eq(IDX.FIN).html('<span class="badge rounded-pill badge-cancelado">Cancelado</span>');
        }
      }

      // A��es
      $tr.find('.btn-cancelar').replaceWith('�');
    }

    if (IS_ADMIN){
      $(document).on('click', '.fin-badge', function(){
        const $btn = $(this);
        const $tr  = $btn.closest('tr');
        if(($tr.data('status')||'').toLowerCase()==='cancelled') return;

        const id   = parseInt($tr.data('id'), 10) || 0;
        if(!id) return;

        const antigo = ($tr.attr('data-fin') || 'nao-pago');
        const novo   = $btn.attr('data-next') || (antigo === 'pago' ? 'nao-pago' : 'pago');

        $btn.prop('disabled', true);
        aplicarUIAcerto($tr, novo);
        atualizarTotais();

        salvarAcerto(id, novo)
          .fail(xhr=>{
            aplicarUIAcerto($tr, antigo);
            atualizarTotais();
            window.location.reload();
          })
          .always(()=> $btn.prop('disabled', false));
      });

      $(document).on('click', '.btn-cancelar', function(){
        const $btn = $(this);
        const $tr  = $btn.closest('tr');
        const id   = parseInt($tr.data('id'), 10) || 0;
        if(!id) return;

        if(!confirm('Confirmar cancelamento do pedido #' + id + '?')) return;

        $btn.prop('disabled', true).text('Cancelando...');
        cancelarPedido(id)
          .done(()=>{ aplicarUICancelado($tr); atualizarTotais(); })
          .fail(xhr=>{ window.location.reload(); })
          .always(()=> $btn.remove());
      });

      function aplicarLote(st){
        const sel = tb.rows({selected:true});
        if(sel.count()===0){ alert('Selecione ao menos um.'); return; }
        $('#lote-ind').show();
        const reqs=[];
        sel.every(function(){
          const $tr = $(this.node());
          const id  = parseInt($tr.data('id'), 10) || 0;
          const stPedido = ($tr.data('status')||'').toLowerCase();
          if(!id || stPedido==='cancelled') return;
          aplicarUIAcerto($tr, st);
          reqs.push( salvarAcerto(id, st) );
        });
        $.when.apply($, reqs)
          .always(function(){
            $('#lote-ind').hide();
            atualizarTotais();
            tb.rows().deselect();
          });
      }
      $('#lote-pago').on('click', ()=> aplicarLote('pago'));
      $('#lote-npago').on('click', ()=> aplicarLote('nao-pago'));
    }
  });
  </script>



<style>


/* ================================
   WooCommerce - Minha Conta (Pedidos)
   Layout 100% largura, sem sidebar
   ================================ */

/* Oculta a navegação lateral */
body.woocommerce-account .woocommerce-MyAccount-navigation {
  display: none !important;
}

/* Força o conteúdo a ocupar toda a largura */
body.woocommerce-account .woocommerce-MyAccount-content {
  width: 100% !important;
  max-width: 100% !important;
  float: none !important;
  margin: 0 auto !important;
  padding: 0 !important;
}

/* Garante que a área principal também estique */
body.woocommerce-account .content-area,
body.woocommerce-account #primary {
  width: 100% !important;
  max-width: 100% !important;
}

/* Remove possíveis espaçamentos que sobram */
body.woocommerce-account .site-main {
  margin: 0 !important;
  padding: 0 !important;
}

/* Ajusta a tabela para expandir bem */
body.woocommerce-account .woocommerce-MyAccount-content table {
  width: 100% !important;
  max-width: 100% !important;
}

/* Cards de totais (financeiro) — garante responsividade */
body.woocommerce-account .cards {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
  gap: 12px;
  margin: 10px 0 14px;
}

.entry-header {


  display: none;
}

</style>
 
<?php
else :
  wc_print_notice(__('Nenhum pedido foi feito ainda.', 'woocommerce'), 'notice');
endif;


