<?php
/**
 * Minha Conta  Pedidos  Controle Financeiro (Admin v tudo, Author s o dele)
 * - Meta: _financeiro_status  ('pago' | 'nao-pago')
 * - Somente ADMIN altera Status Financeiro; Author apenas visualiza
 * - Endpoint inline (financeiro_api=1) salva no prprio arquivo
 * - DataTables: Buttons + Select + Responsive (mobile-friendly)
 */
defined('ABSPATH') || exit;

/* =========================================================
 * 1) ENDPOINT INLINE (POST)  /minha-conta/orders/?financeiro_api=1
 * ========================================================= */
if (isset($_REQUEST['financeiro_api']) && $_REQUEST['financeiro_api'] == '1') {
    nocache_headers();

    if (!is_user_logged_in()) {
        wp_send_json_error(['msg'=>'Login necessrio'], 401);
    }
    if (!current_user_can('administrator')) { // <-- S ADMIN pode mudar
        wp_send_json_error(['msg'=>'Sem permisso para alterar o status financeiro'], 403);
    }

    $nonce = $_REQUEST['nonce'] ?? '';
    if (!wp_verify_nonce($nonce, 'set_status_financeiro')) {
        wp_send_json_error(['msg'=>'Nonce invlido/expirado'], 403);
    }

    $order_id = absint($_REQUEST['order_id'] ?? 0);
    $status   = sanitize_text_field($_REQUEST['status'] ?? '');
    if (!$order_id || !in_array($status, ['pago','nao-pago'], true)) {
        wp_send_json_error(['msg'=>'Parmetros invlidos'], 400);
    }

    $order = wc_get_order($order_id);
    if (!$order) {
        wp_send_json_error(['msg'=>'Pedido no encontrado'], 404);
    }

    $order->update_meta_data('_financeiro_status', $status);
    $order->save();

    wp_send_json_success(['ok'=>true, 'order_id'=>$order_id, 'status'=>$status]);
    exit;
}

/* =========================================================
 * 2) Variveis / Nonce / URL endpoint para o JS
 * ========================================================= */
$is_admin   = current_user_can('administrator'); // s admin edita
$is_author  = current_user_can('author');
$nonce_fin  = wp_create_nonce('set_status_financeiro');
$orders_url = wc_get_endpoint_url('orders', '', wc_get_page_permalink('myaccount'));
$endpoint_url = esc_url( add_query_arg('financeiro_api','1', $orders_url) );

// Datas padro: ltimos 30 dias
$now_ts     = current_time('timestamp');
$default_to = date('Y-m-d', $now_ts);
$default_fr = date('Y-m-d', $now_ts - 29*DAY_IN_SECONDS);

// expe ao JS
echo '<script>window.FIN_NONCE="'.esc_js($nonce_fin).'";window.FIN_URL="'.esc_js($endpoint_url).'";window.DEFAULT_FROM="'.esc_js($default_fr).'";window.DEFAULT_TO="'.esc_js($default_to).'";</script>';

/* =========================================================
 * 3) Cabealho Woo padro
 * ========================================================= */
do_action('woocommerce_before_account_orders', $has_orders);

/* =========================================================
 * 4) Monta coleo de pedidos conforme permisso
 *    - ADMIN: todos
 *    - AUTHOR: somente post_author = usurio atual
 *    - OUTROS (cliente): mantm os do Woo (se houver)
 * ========================================================= */
$orders_list = [];
if ($is_admin || $is_author) {
    // Busca geral e filtra por autor quando necessrio
    $all_ids = wc_get_orders([
        'status'  => array_keys(wc_get_order_statuses()),
        'limit'   => -1,
        'orderby' => 'date',
        'order'   => 'DESC',
        'return'  => 'ids',
    ]);
    $uid = get_current_user_id();
    foreach ($all_ids as $oid) {
        if ($is_author) {
            if ((int) get_post_field('post_author', $oid) !== $uid) {
                continue; // author v s o dele
            }
        }
        $orders_list[] = wc_get_order($oid);
    }
} else {
    // Fallback: usa a coleo padro do template (pedidos do cliente)
    if (!empty($customer_orders->orders)) {
        foreach ($customer_orders->orders as $co) {
            $orders_list[] = wc_get_order($co);
        }
    }
}

/* =========================================================
 * 5) UI + Tabela
 * ========================================================= */
if (!empty($orders_list)) :

  // Combos de filtro (transporte/pontos/pagamento) e Operador (s admin)
  $transportes=$embarques=$desembarques=$pagamentos=$operadores=[];
  foreach($orders_list as $o){
    if(!$o) continue;
    $it = reset($o->get_items());
    $trans = $it ? $it->get_name()           : '';
    $orig  = $it ? $it->get_meta('_wbtm_bp') : $o->get_meta('_wbtm_bp');
    $dest  = $it ? $it->get_meta('_wbtm_dp') : $o->get_meta('_wbtm_dp');
    $met   = $o->get_payment_method_title();

    $author_id = (int) get_post_field('post_author', $o->get_id());
    $oper      = $author_id ? get_the_author_meta('display_name', $author_id) : '';

    if($trans && !in_array($trans,$transportes,true))   $transportes[]=$trans;
    if($orig  && !in_array($orig,$embarques,true))      $embarques[]=$orig;
    if($dest  && !in_array($dest,$desembarques,true))   $desembarques[]=$dest;
    if($met   && !in_array($met,$pagamentos,true))      $pagamentos[]=$met;
    if($is_admin && $oper && !in_array($oper,$operadores,true)) $operadores[]=$oper;
  }
  sort($transportes); sort($embarques); sort($desembarques); sort($pagamentos); sort($operadores);
  ?>

  <!-- Cards Totais -->
  <div class="cards">
    <div class="card aberto"><div class="t">Em aberto</div><div class="v" id="total-aberto">R$ 0,00</div></div>
    <div class="card pago"><div class="t">Pago</div><div class="v" id="total-pago">R$ 0,00</div></div>
    <div class="card vendas"><div class="t">Total de Vendas (filtrado)</div><div class="v" id="total-vendas">R$ 0,00</div></div>
  </div>

  <!-- Toggle Filtros (mobile) -->
  <button class="btn-filtros-toggle" aria-expanded="false" aria-controls="filtros">Mostrar filtros</button>

  <!-- Filtros -->
  <div id="filtros" class="filtros" data-collapsible>
    <div><label>Data inicial</label><input type="date" id="fDataIni" value="<?php echo esc_attr($default_fr); ?>"></div>
    <div><label>Data final</label><input type="date" id="fDataFim" value="<?php echo esc_attr($default_to); ?>"></div>

    <?php if($is_admin): ?>
    <div><label>Operador</label>
      <select id="fOp"><option value="">Todos</option><?php foreach($operadores as $op) echo '<option>'.esc_html($op).'</option>'; ?></select>
    </div>
    <?php endif; ?>

    <div><label>Transporte</label>
      <select id="fTrans"><option value="">Todos</option><?php foreach($transportes as $t) echo '<option>'.esc_html($t).'</option>'; ?></select>
    </div>
    <div><label>Embarque</label>
      <select id="fEmb"><option value="">Todos</option><?php foreach($embarques as $e) echo '<option>'.esc_html($e).'</option>'; ?></select>
    </div>
    <div><label>Desembarque</label>
      <select id="fDes"><option value="">Todos</option><?php foreach($desembarques as $d) echo '<option>'.esc_html($d).'</option>'; ?></select>
    </div>
    <div><label>Mtodo de pagamento</label>
      <select id="fMet"><option value="">Todos</option><?php foreach($pagamentos as $p) echo '<option>'.esc_html($p).'</option>'; ?></select>
    </div>
    <div><label>Status Financeiro</label>
      <select id="fFin"><option value="">Todos</option><option value="pago">Pago</option><option value="nao-pago">No Pago</option></select>
    </div>
    <div style="align-self:end"><button id="limpar" class="button limpar">Limpar</button></div>
  </div>

  <!-- Aes em lote (ADMIN) -->
  <?php if($is_admin): ?>
  <div class="lote">
    <strong>Aes em lote:</strong>
    <button id="lote-pago"  class="button">Marcar como Pago</button>
    <button id="lote-npago" class="button">Marcar como No Pago</button>
    <span id="lote-ind" style="display:none;margin-left:8px">Salvando</span>
  </div>
  <?php endif; ?>

  <!-- Tabela -->
  <table id="tb" class="display nowrap" style="width:100%">
    <thead>
      <tr>
        <th></th> <!-- controle responsive -->
        <?php if($is_admin): ?><th></th><?php endif; ?> <!-- select-checkbox (s admin) -->
        <th>Pedido</th>
        <th>Data</th>
        <th>Operador</th>
        <th>Transporte</th>
        <th>Embarque</th>
        <th>Desembarque</th>
        <th>Total</th>
        <th>Mtodo de Pagamento</th>
        <th>Status Financeiro</th>
      </tr>
    </thead>
    <tbody>
      <?php
      foreach ($orders_list as $o) {
        if(!$o) continue;
        $id   = $o->get_id();
        $url  = esc_url($o->get_view_order_url());
        $num  = esc_html($o->get_order_number());
        $dt   = $o->get_date_created();
        $date_iso = $dt ? $dt->date('Y-m-d') : '';
        $data = $dt ? date_i18n('d/m/Y', $dt->getTimestamp()) : '';

        // Operador (autor do pedido)
        $author_id = (int) get_post_field('post_author', $id);
        $operador  = $author_id ? get_the_author_meta('display_name', $author_id) : '';

        $met  = $o->get_payment_method_title();
        $it   = reset($o->get_items());
        $trans = $it ? $it->get_name()           : '-';
        $orig  = $it ? $it->get_meta('_wbtm_bp') : $o->get_meta('_wbtm_bp');
        $dest  = $it ? $it->get_meta('_wbtm_dp') : $o->get_meta('_wbtm_dp');
        $tot   = (float)$o->get_total();

        $fin  = $o->get_meta('_financeiro_status') ?: 'nao-pago';
        $row_class = $fin==='pago' ? '' : 'npago';

        if ($is_admin) {
          $fin_html = '<div class="fin" data-order-id="'.$id.'">
            <label class="fin-opt"><input type="radio" name="fin_'.$id.'" value="pago" '.checked($fin,'pago',false).'> Pago</label>
            <label class="fin-opt"><input type="radio" name="fin_'.$id.'" value="nao-pago" '.checked($fin,'nao-pago',false).'> No Pago</label>
            <span class="saving" aria-live="polite" style="display:none">Salvando</span>
          </div>';
        } else {
          $rot = $fin==='pago' ? 'Pago' : 'No Pago';
          $cls = $fin==='pago' ? 'badge ok' : 'badge nok';
          $fin_html = '<span class="'.$cls.'">'.$rot.'</span>';
        }

        echo '<tr class="'.$row_class.'" data-fin="'.esc_attr($fin).'" data-total="'.esc_attr($tot).'" data-date="'.esc_attr($date_iso).'">';
        echo '<td></td>'; // control col
        if($is_admin) echo '<td></td>'; // select col
        echo '<td><a href="'.$url.'">#'.$num.'</a></td>';
        echo '<td>'.$data.'</td>';
        echo '<td>'.esc_html($operador).'</td>';
        echo '<td>'.esc_html($trans).'</td>';
        echo '<td>'.esc_html($orig).'</td>';
        echo '<td>'.esc_html($dest).'</td>';
        echo '<td>R$ '.number_format($tot,2,',','.').'</td>';
        echo '<td>'.esc_html($met).'</td>';
        echo '<td>'.$fin_html.'</td>';
        echo '</tr>';
      }
      ?>
    </tbody>
  </table>

  <!-- CSS / Libs -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/select/1.7.0/css/select.dataTables.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">
  <style>
    /* Cards */
    .cards{
      display:grid;
      grid-template-columns:repeat(3,minmax(200px,1fr));
      gap:12px; margin:10px 0 14px
    }
    .card{padding:16px;border-radius:10px;color:#fff}
    .card .t{opacity:.85;font-size:13px}
    .card .v{font-size:22px;font-weight:700;margin-top:4px}
    .card.aberto{background:#dc3545}.card.pago{background:#28a745}.card.vendas{background:#1e88e5}

    /* Filtros */
    .btn-filtros-toggle{
      display:none; margin:4px 0 8px; padding:10px 12px; border-radius:8px;
      border:1px solid #ddd; background:#f7f7f7; font-weight:600; width:100%; text-align:center
    }
    .filtros{
      display:grid; grid-template-columns:repeat(9,1fr); gap:8px; margin:8px 0 12px
    }
    .filtros label{display:block;font-size:12px;margin-bottom:2px}
    .filtros input,.filtros select{padding:8px;border:1px solid #ddd;border-radius:8px;width:100%}
    .button.limpar{background:#ffb300;border:none;font-weight:600;padding:8px 12px;border-radius:8px}

    /* Aes em lote */
    .lote{margin:6px 0 12px}

    /* Badges e linhas no pagas */
    .badge{padding:.2rem .5rem;border-radius:6px;color:#fff}
    .badge.ok{background:#28a745}.badge.nok{background:#dc3545}
    tr.npago td{background:#fff8f8}

    /* DataTables: botes quebram linha no mobile */
    .dt-buttons{display:flex;flex-wrap:wrap;gap:8px}

    /* Controles financeiros com rea de toque */
    .fin{display:flex;flex-wrap:wrap;gap:10px;align-items:center}
    .fin-opt{display:flex;gap:6px;align-items:center;padding:6px 8px;border:1px solid #eee;border-radius:8px}

    /* Responsividade */
    @media (max-width: 980px){
      .cards{grid-template-columns:repeat(2,minmax(0,1fr))}
      .btn-filtros-toggle{display:block}
      .filtros[data-collapsible]{display:none}
      .filtros[data-open="1"]{display:grid}
      .filtros{grid-template-columns:repeat(2,1fr)}
    }
    @media (max-width: 640px){
      .cards{grid-template-columns:1fr}
    }
  </style>

  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
  <script src="https://cdn.datatables.net/select/1.7.0/js/dataTables.select.min.js"></script>
  <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>

  <script>
  jQuery(function($){
    const IS_ADMIN = <?php echo $is_admin ? 'true' : 'false'; ?>;
    const BRL = v => (Number(v)||0).toLocaleString('pt-BR',{style:'currency',currency:'BRL'});

    // ndices: com coluna de controle "CTL" (0) e (1) select p/ admin
    const IDX = IS_ADMIN
      ? {CTL:0,SEL:1,PED:2,DT:3,OP:4,TR:5,EMB:6,DES:7,TOT:8,MET:9,FIN:10}
      : {CTL:0,PED:1,DT:2,OP:3,TR:4,EMB:5,DES:6,TOT:7,MET:8,FIN:9};

    // Toggle de filtros no mobile
    const $btnFiltros = $('.btn-filtros-toggle');
    const $filtros = $('#filtros');
    $btnFiltros.on('click', function(){
      const open = $filtros.attr('data-open') === '1' ? '0' : '1';
      $filtros.attr('data-open', open);
      this.setAttribute('aria-expanded', open==='1' ? 'true' : 'false');
      this.textContent = open==='1' ? 'Ocultar filtros' : 'Mostrar filtros';
    });

    // DataTable responsivo com coluna de controle
    const opts = {
      responsive: { details: { type:'column', target: 0 } },
      dom:'Bfrtip',
      order:[[ IS_ADMIN?IDX.DT:IDX.DT, 'desc' ]],
      language:{ url:'//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' },
      buttons: IS_ADMIN ? [
        { text:'Selecionar (filtrados)', action:(e,dt)=> dt.rows({search:'applied'}).select() },
        { text:'Limpar seleo',         action:(e,dt)=> dt.rows().deselect() },
        { extend:'copy',  text:'Copiar'  },
        { extend:'excel', text:'Excel'   },
        { extend:'print', text:'Imprimir'}
      ] : [
        { extend:'copy',  text:'Copiar'  },
        { extend:'excel', text:'Excel'   },
        { extend:'print', text:'Imprimir'}
      ],
      columnDefs: [
        {targets: 0, className:'control', orderable:false, searchable:false},
        {targets: IS_ADMIN?IDX.TOT:IDX.TOT, className:'dt-right'},
        // Prioridades para mobile
        {targets: [IS_ADMIN?IDX.PED:IDX.PED, IS_ADMIN?IDX.DT:IDX.DT, IS_ADMIN?IDX.TOT:IDX.TOT, IS_ADMIN?IDX.FIN:IDX.FIN], responsivePriority: 1},
        {targets: [IS_ADMIN?IDX.OP:IDX.OP], responsivePriority: 2},
        {targets: '_all', responsivePriority: 100}
      ]
    };
    if (IS_ADMIN){
      opts.select = { style:'multi', selector:'td.select-checkbox' };
      opts.columnDefs.splice(1, 0, {targets:IDX.SEL, className:'select-checkbox', orderable:false, searchable:false});
    }
    const tb = $('#tb').DataTable(opts);
    if(!IS_ADMIN){ tb.column(1).visible(false); } // oculta col de seleo p/ no-admin

    // Totais (filtrados)
    function atualizarTotais(){
      let pago=0, aberto=0, vendas=0;
      tb.rows({search:'applied'}).every(function(){
        const tr = this.node();
        const v  = parseFloat(tr.dataset.total||'0')||0;
        const st = tr.dataset.fin || 'nao-pago';
        vendas += v;
        if(st==='pago') pago+=v; else aberto+=v;
      });
      $('#total-pago').text(BRL(pago));
      $('#total-aberto').text(BRL(aberto));
      $('#total-vendas').text(BRL(vendas));
    }

    // Filtros custom (inclui Operador p/ admin)
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex){
      if(settings.nTable.id!=='tb') return true;
      const tr = tb.row(dataIndex).node();
      const dIso = tr.dataset.date || ''; // YYYY-MM-DD
      const di = $('#fDataIni').val() || '';
      const df = $('#fDataFim').val() || '';
      if(di && dIso < di) return false;
      if(df && dIso > df) return false;

      const fOp = $('#fOp').val()   || ''; // Operador (admin)
      const fT  = $('#fTrans').val()|| '';
      const fE  = $('#fEmb').val()  || '';
      const fD  = $('#fDes').val()  || '';
      const fM  = $('#fMet').val()  || '';
      const fF  = $('#fFin').val()  || '';

      const iOP = IS_ADMIN ? IDX.OP : IDX.OP;
      const iTR = IS_ADMIN ? IDX.TR : IDX.TR;
      const iEM = IS_ADMIN ? IDX.EMB: IDX.EMB;
      const iDE = IS_ADMIN ? IDX.DES: IDX.DES;
      const iME = IS_ADMIN ? IDX.MET: IDX.MET;

      if(fOp && (data[iOP]||'') !== fOp) return false; // filtro por operador
      if(fT  && (data[iTR]||'') !== fT)  return false;
      if(fE  && (data[iEM]||'') !== fE)  return false;
      if(fD  && (data[iDE]||'') !== fD)  return false;
      if(fM  && (data[iME]||'') !== fM)  return false;

      if(fF){
        if((tr.dataset.fin||'') !== fF) return false;
      }
      return true;
    });

    // Aplica filtro inicial (ltimos 30 dias)
    function aplicarFiltroInicial(){
      if(!$('#fDataIni').val()) $('#fDataIni').val(window.DEFAULT_FROM || '');
      if(!$('#fDataFim').val()) $('#fDataFim').val(window.DEFAULT_TO   || '');
      tb.draw();
      atualizarTotais();
    }

    // Eventos de filtro
    $('#fDataIni,#fDataFim,#fOp,#fTrans,#fEmb,#fDes,#fMet,#fFin').on('change', ()=> { tb.draw(); atualizarTotais(); });
    $('#limpar').on('click', function(){
      $('#fDataIni').val(window.DEFAULT_FROM || '');
      $('#fDataFim').val(window.DEFAULT_TO   || '');
      $('#fOp,#fTrans,#fEmb,#fDes,#fMet,#fFin').val('');
      tb.search('').columns().search('');
      tb.draw(); atualizarTotais();
    });

    aplicarFiltroInicial(); // comea pelos ltimos 30 dias

    // ===== Salvamento (ADMIN) =====
    function salvar(orderId, status, $ctx){
      const $s = $ctx.find('.saving'); $s.show();
      return $.ajax({
        url: window.FIN_URL,
        method: 'POST',
        dataType: 'json',
        data: { nonce: window.FIN_NONCE, order_id: orderId, status: status, financeiro_api: 1 }
      }).always(()=> $s.hide());
    }

    if (IS_ADMIN){
      // Radio individual
      $(document).on('change','.fin input[type=radio]', function(){
        const $r = $(this), $wrap = $r.closest('.fin');
        const orderId = parseInt($wrap.data('order-id'),10)||0;
        const status  = $r.val();
        const $tr     = $r.closest('tr');
        $tr.attr('data-fin', status);
        if(status==='pago') $tr.removeClass('npago'); else $tr.addClass('npago');
        salvar(orderId, status, $wrap).done(()=> atualizarTotais())
          .fail(xhr=> alert(xhr.responseJSON?.msg || 'Falha ao salvar'));
      });

      // Lote
      function aplicarLote(st){
        const sel = tb.rows({selected:true}); if(sel.count()===0){ alert('Selecione ao menos um.'); return; }
        $('#lote-ind').show();
        const reqs=[];
        sel.every(function(){
          const $tr = $(this.node());
          const $fin = $tr.find('.fin');
          const id = parseInt($fin.data('order-id')||'0',10);
          $tr.attr('data-fin', st);
          if(st==='pago') $tr.removeClass('npago'); else $tr.addClass('npago');
          $fin.find('input[value="'+st+'"]').prop('checked', true);
          reqs.push( salvar(id, st, $fin) );
        });
        $.when.apply($, reqs).always(function(){
          $('#lote-ind').hide();
          atualizarTotais();
          tb.rows().deselect();
        });
      }
      $('#lote-pago').on('click', ()=> aplicarLote('pago'));
      $('#lote-npago').on('click', ()=> aplicarLote('nao-pago'));
    }
  });
  </script>

<?php
else :
  wc_print_notice( __('Nenhum pedido foi feito ainda.','woocommerce'), 'notice' );
endif;

do_action('woocommerce_after_account_orders', $has_orders);
