"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _url = require("@wordpress/url");

/**
 * WordPress dependencies
 */

/**
 * @type {import('../types').APIFetchMiddleware}
 */
const userLocaleMiddleware = (options, next) => {
  if (typeof options.url === 'string' && !(0, _url.hasQueryArg)(options.url, '_locale')) {
    options.url = (0, _url.addQueryArgs)(options.url, {
      _locale: 'user'
    });
  }

  if (typeof options.path === 'string' && !(0, _url.hasQueryArg)(options.path, '_locale')) {
    options.path = (0, _url.addQueryArgs)(options.path, {
      _locale: 'user'
    });
  }

  return next(options);
};

var _default = userLocaleMiddleware;
exports.default = _default;
//# sourceMappingURL=user-locale.js.map