<?php
	/*
* @Author 		engr.sumonazma@gmail.com
* Copyright: 	mage-people.com
*/
	if (!defined('ABSPATH')) {
		die;
	} // Cannot access pages directly.
	if (!class_exists('WBTM_Reports')) {
		class WBTM_Reports {
			public function __construct() {
				add_action('admin_menu', array($this, 'report_menu'));
				/**********************************/
				add_action('wp_ajax_get_wbtm_report_filter_result', array($this, 'get_wbtm_report_filter_result'));
				add_action('wp_ajax_nopriv_get_wbtm_report_filter_result', array($this, 'get_wbtm_report_filter_result'));
			}
			public function report_menu() {
				$cpt = WBTM_Functions::get_cpt();
				add_submenu_page('edit.php?post_type=' . $cpt, esc_html__('Sales Report', 'addon-bus--ticket-booking-with-seat-pro'), esc_html__('Sales Report', 'addon-bus--ticket-booking-with-seat-pro'), 'manage_options', 'wbtm_sales_report', array($this, 'sales_report'));
			}
			public function sales_report() {
				?>
				<div class="wrap">
					<div class="wbtm_style wbtm_sales_report_area wbtm_admin_page">
						<?php $this->total_info(); ?>
						<?php $this->filter_selection(); ?>
						<div class="wbtm_filter_result" id="wbtm_sales_report_result">
							<?php $this->sales_filter_result(); ?>
						</div>
					</div>
				</div>
				<style>
					div.notice,
					#update-nag, .update-nag {display: none;}
				</style>
				<?php
			}
			public function filter_selection() {
				$label = WBTM_Functions::get_name();
				?>
				<div class="_dLayout_pRelative placeholder_area wbtm_report_filter_section">
					<h4 class="title_on_border"><?php echo esc_html($label) . ' ' . esc_html__('Sales Report Filter By', 'addon-bus--ticket-booking-with-seat-pro'); ?></h4>
					<div class="wbtm_filter_form inputInline" data-placeholder>
						<div class="mpForm _bgLight_4_padding_xs">
							<?php //WBTM_Layout_Pro::select_user(); ?>
							
							<?php WBTM_Layout_Pro::select_bus(); ?>
							<div class="inputList"></div>
							<div class="inputList"></div>
							<div class="inputList"></div>
						</div>
						<div class="mpForm _mT_xs_bgLight_2_padding_xs">
							<?php WBTM_Layout_Pro::select_journey_date(); ?>
							<?php WBTM_Layout_Pro::select_journey_date_from(); ?>
							<?php WBTM_Layout_Pro::select_journey_date_to(); ?>
							<div class="inputList"></div>
						</div>
						<div class="mpForm _mT_xs_bgLight_2_padding_xs">
							<?php WBTM_Layout_Pro::select_order_date(); ?>
							<?php WBTM_Layout_Pro::select_order_date_from(); ?>
							<?php WBTM_Layout_Pro::select_order_date_to(); ?>
							<div class="inputList"></div>
						</div>
						<div class="mpForm _mT_xs_bgLight_2_padding_xs">
							<?php WBTM_Layout_Pro::select_bp_date(); ?>
							<?php WBTM_Layout_Pro::select_bp_point(); ?>
							<?php WBTM_Layout_Pro::select_dp_point(); ?>
							<div class="inputList">
								<div class="fdColumn justifyBetween fullHeight">
									<span>&nbsp;</span>
									<div class="buttonGroup flexEqual">
										<button class="_themeButton" type="button" id="get_wbtm_sales_report_filter_result"><?php esc_html_e('Filter', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
										<button class="_warningButton" id="wbtm_filter_reset" type="button"><?php esc_html_e('Reset', 'addon-bus--ticket-booking-with-seat-pro'); ?></button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php
			}
			public function total_info() {
				$all_passengers = WBTM_Function_PRO::attendee_query();
				$total_passenger = $all_passengers->post_count;
				$passenger_infos = $all_passengers->posts;
				$total_sale = 0;
				$orders = [];
				$buses = [];
				foreach ($passenger_infos as $passenger) {
					$attendee_id = $passenger->ID;
					$price = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_fare');
					$total_sale = $total_sale + max(0, $price);
					$orders[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
					$buses[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_id');
				}
				?>
				<div class="_dLayout_pRelative placeholder_area">
					<table class="_mb_layoutFixed" data-placeholder>
						<thead>
						<tr>
							<th>
								<h4>
									<?php esc_html_e('Total Sales ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo wc_price($total_sale); ?></strong>
								</h4>
							</th>
							<th>
								<h4>
									<?php esc_html_e('Total Passengers ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo esc_html($total_passenger); ?></strong>
								</h4>
							</th>
							<th>
								<h4>
									<?php esc_html_e('Total Order ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo esc_html(sizeof(array_unique($orders))); ?></strong>
								</h4>
							</th>
							<th>
								<h4>
									<?php esc_html_e('Total Bus ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo esc_html(sizeof(array_unique($buses))); ?></strong>
								</h4>
							</th>
						</tr>
						</thead>
					</table>
				</div>
				<?php
			}
			public function sales_filter_result() {
				$filter_args = isset($_REQUEST['filter_args']) ? WBTM_Global_Function::data_sanitize($_REQUEST['filter_args']) : [];
				$all_passengers = WBTM_Function_PRO::attendee_query($filter_args);
				$total_passenger = $all_passengers->post_count;
				$passenger_infos = $all_passengers->posts;
				$all_buses = [];
				$orders = [];
				$total_sale = 0;
				foreach ($passenger_infos as $passenger) {
					$attendee_id = $passenger->ID;
					$bus_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_id');
					$order_id = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
					$price = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_bus_fare');
					$current_price = array_key_exists($bus_id, $all_buses) && array_key_exists('price', $all_buses[$bus_id]) ? $all_buses[$bus_id]['price'] : 0;
					$all_buses[$bus_id]['attendee_id'][] = $attendee_id;
					$all_buses[$bus_id]['order_id'][] = $order_id;
					$all_buses[$bus_id]['price'] = max(0, $current_price) + max(0, $price);
					$orders[] = WBTM_Global_Function::get_post_info($attendee_id, 'wbtm_order_id');
					$total_sale = $total_sale + max(0, $price);
				}
				?>
				<div class="_dLayout_pRelative placeholder_area">
					<table class="_mb_layoutFixed" data-placeholder>
						<thead>
						<tr>
							<th>
								<h4>
									<?php esc_html_e('Total Sales ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo wc_price($total_sale); ?></strong>
								</h4>
							</th>
							<th>
								<h4>
									<?php esc_html_e('Total Passengers ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo esc_html($total_passenger); ?></strong>
								</h4>
							</th>
							<th>
								<h4>
									<?php esc_html_e('Total Order ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo esc_html(sizeof(array_unique($orders))); ?></strong>
								</h4>
							</th>
							<th>
								<h4>
									<?php esc_html_e('Total Bus ', 'addon-bus--ticket-booking-with-seat-pro'); ?> :
									<strong class="textTheme"><?php echo esc_html(sizeof($all_buses)); ?></strong>
								</h4>
							</th>
						</tr>
						</thead>
					</table>
					<?php $this->report_table($all_buses, $filter_args); ?>
				</div>
				<?php
				//echo '<pre>'; print_r($total_sale); echo '</pre>';
				//echo '<pre>'; print_r($all_buses); echo '</pre>';
			}
			public function report_table($all_buses, $filter_args) {
				if (sizeof($all_buses) > 0) {
					?>
					<table class="groupCheckBox" data-placeholder>
						<thead>
						<tr>
							<th class="_w_50"><?php esc_html_e('SI.', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_textLeft"><?php echo esc_html(WBTM_Functions::get_name()); ?></th>
							<th><?php esc_html_e('Total Passenger', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th><?php esc_html_e('Total Order', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th><?php esc_html_e('Total Sale', 'addon-bus--ticket-booking-with-seat-pro'); ?></th>
							<th class="_w_150"><?php echo WBTM_Translations::text_action(); ?></th>
						</tr>
						</thead>
						<tbody>
						<?php
							$count = 1;
							foreach ($all_buses as $bus_id => $bus_info) {
								$filter_args['wbtm_bus_id'] = $bus_id;
								$download_url = WBTM_Pro_Pdf::get_pdf_url($filter_args);
								$category = WBTM_Global_Function::get_post_info($bus_id, 'wbtm_bus_category');
								?>
								<tr>
									<th><?php echo esc_html($count); ?></th>
									<th class="_textLeft">
										<a class="textBlack" href="<?php echo get_the_permalink($bus_id); ?>" target="_blank">
											<?php echo esc_html(get_the_title($bus_id) . '(' . $category . ')'); ?>
										</a>
										<small><?php echo esc_html(WBTM_Global_Function::get_post_info($bus_id, 'wbtm_bus_no')); ?></small>
									</th>
									<th><?php echo esc_html(sizeof($bus_info['attendee_id'])); ?></th>
									<th><?php echo esc_html(sizeof(array_unique($bus_info['order_id']))); ?></th>
									<th><?php echo wc_price($bus_info['price']); ?></th>
									<th>
										<div class="buttonGroup">
											<button class="_mpBtn_xs_textWarning" type="button" title="<?php esc_attr_e('Download Pdf.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-href="<?php echo esc_attr($download_url); ?>">
												<span class="fas fa-file-pdf mp_zero"></span>
											</button>
											<button class="_mpBtn_xs_textSuccess" type="button" title="<?php esc_attr_e('Download CSV.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-href="<?php echo esc_attr(WBTM_CSV::get_csv_url($filter_args)); ?>">
												<span class="fas fa-file-csv mp_zero"></span>
											</button>
											<button class="_mpBtn_xs_textGray" type="button" data-collapse-target="wbtm_expand_<?php echo esc_attr($bus_id); ?>" title="<?php esc_attr_e('Open Order Details.', 'addon-bus--ticket-booking-with-seat-pro'); ?>" data-open-icon="fa-eye" data-close-icon="fa-eye-slash">
												<span data-icon class="fas fa-eye mp_zero"></span>
											</button>
										</div>
									</th>
								</tr>
								<tr data-collapse="wbtm_expand_<?php echo $bus_id; ?>">
									<td colspan="6">
										<?php WBTM_Passenger_List::passenger_table($bus_info['attendee_id']); ?>
									</td>
								</tr>
								<?php
								$count++;
							}
						?>
						</tbody>
					</table>
				<?php } else { ?>
					<p style="text-align: center;"><?php esc_html_e('No Record Found.', 'addon-bus--ticket-booking-with-seat-pro'); ?></p>
					<?php
				}
			}
			//********************//
			public function get_wbtm_report_filter_result() {
				$this->sales_filter_result();
				die();
			}
		}
		new WBTM_Reports();
	}