# Bus Ticket Booking with Seat Pro - Enhanced Passenger List Features

## Overview
This plugin provides comprehensive bus ticket booking functionality with advanced passenger list management, filtering, and reporting capabilities.

## Recent Enhancements

### 1. Enhanced Passenger List Filtering (v2.1)
- **Date-based Filtering**: Filter passengers by journey date, order date, or boarding date
- **Multi-field Search**: Search by passenger name, email, phone, address, and custom fields
- **Dynamic Custom Fields**: Automatically loads custom attendee fields based on selected bus
- **Filter Status Indicator**: Visual feedback showing active filters
- **Download Integration**: PDF and CSV downloads respect all applied filters

### 2. Improved PDF Generation (v2.2)
- **Smart PDF Detection**: Automatically generates passenger list PDF when filters are applied
- **Multi-bus Support**: Handles scenarios with multiple buses in filtered results
- **Enhanced Templates**: Comprehensive passenger information display
- **Date-only Filtering**: Generates passenger list PDF even when only date filters are applied

### 3. Seat Number Sorting Feature (v2.3) ⭐ **NEW**
- **Checkbox Control**: Toggle seat sorting with a simple checkbox
- **Smart Sorting Logic**: Handles alphanumeric seat formats (A1, B12, etc.)
- **Visual Feedback**: Checkbox styling indicates when sorting is active
- **State Persistence**: Maintains sorting preference across pagination and filter changes
- **Download Integration**: PDF and CSV downloads respect the sorting preference
- **Original Order Restoration**: Properly restores original order when sorting is disabled

#### Seat Sorting Features:
- **Alphanumeric Support**: Correctly sorts seat numbers like A1, A2, B1, B2, etc.
- **Letter Priority**: Sorts by row (letter) first, then by column (number)
- **Fallback Handling**: Gracefully handles invalid or missing seat numbers
- **Performance Optimized**: Efficient sorting algorithm for large passenger lists

### 4. Enhanced User Experience
- **Responsive Design**: Works seamlessly on desktop and mobile devices
- **Loading States**: Visual feedback during AJAX operations
- **Error Handling**: Graceful error handling with user-friendly messages
- **Accessibility**: Proper ARIA labels and keyboard navigation support

## Technical Implementation

### JavaScript Enhancements
- **Original Order Storage**: Maintains reference to original row order for restoration
- **Dynamic Sorting**: Client-side sorting with server-side backup
- **Filter State Management**: Tracks and displays active filter status
- **Event Handling**: Proper event delegation for dynamic content

### PHP Backend Improvements
- **Query Optimization**: Efficient database queries with proper indexing
- **Sorting Integration**: Server-side sorting for consistent results
- **Parameter Validation**: Robust input sanitization and validation
- **Memory Management**: Optimized for large datasets

### Database Considerations
- **Meta Query Optimization**: Efficient filtering using WordPress meta queries
- **Indexing Recommendations**: Proper database indexing for performance
- **Query Caching**: Implements caching strategies for repeated queries

## Usage Instructions

### Basic Filtering
1. Navigate to **Bus > Passenger List** in the admin panel
2. Use the filter form to select criteria (bus, date, passenger info, etc.)
3. Click **Filter** to apply filters
4. Use **Reset** to clear all filters

### Seat Sorting
1. Apply any desired filters to narrow down the passenger list
2. Check the **"Sort by Seat Number"** checkbox to enable seat sorting
3. The list will automatically reorder by seat number
4. Uncheck the box to restore the original order
5. Download PDF/CSV will maintain the current sorting preference

### Advanced Filtering
1. **Custom Fields**: Select a bus to load its custom attendee fields
2. **Global Search**: Leave bus unselected to search across all buses
3. **Date Ranges**: Use date pickers for precise date filtering
4. **Text Search**: Use text fields for partial matching

### Download Options
- **PDF Download**: Generates comprehensive passenger list with all details
- **CSV Download**: Exports data in spreadsheet format
- **Sorting Respect**: Downloads maintain current sorting preference
- **Filter Respect**: Downloads include only filtered results

## Configuration

### PDF Settings
- Configure PDF appearance in **Bus > Settings > PDF Settings**
- Customize header, footer, and content display options
- Set default sorting preferences

### CSV Settings
- Configure CSV export options in **Bus > Settings > CSV Settings**
- Choose which columns to include in exports
- Set default formatting options

### Performance Settings
- Configure pagination limits for optimal performance
- Set caching preferences for large datasets
- Adjust query optimization settings

## Troubleshooting

### Common Issues
1. **Sorting Not Working**: Ensure seat numbers are properly formatted
2. **Slow Performance**: Check database indexing and reduce pagination size
3. **PDF Generation Issues**: Verify mPDF library installation
4. **Filter Not Working**: Check field names and data format

### Debug Mode
Enable debug mode in WordPress to see detailed error messages:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

## Changelog

### Version 5.2.7 (Current)
- ✅ **Added**: Csv generation added in sales generation

### Version 2.3 (Current)
- ✅ **Fixed**: Seat sorting now properly restores original order when disabled
- ✅ **Fixed**: PDF and CSV downloads now respect sorting preference
- ✅ **Fixed**: Table column structure corrected - "Ticket" column renamed to "Seat" for clarity
- ✅ **Enhanced**: Improved seat number detection and sorting algorithm
- ✅ **Added**: Visual feedback for active sorting state
- ✅ **Improved**: Better error handling and user feedback
- ✅ **Fixed**: Server-side sorting now properly handles alphanumeric seat numbers (B3, C4, D3, etc.)

### Version 2.2
- ✅ **Fixed**: PDF generation for date-only filtering
- ✅ **Enhanced**: Multi-bus passenger list support
- ✅ **Improved**: Template structure and styling

### Version 2.1
- ✅ **Added**: Date-based filtering capabilities
- ✅ **Added**: Dynamic custom field loading
- ✅ **Added**: Filter status indicators
- ✅ **Enhanced**: Download integration

## Support

For technical support or feature requests, please contact the development team.

---

**Note**: This plugin requires WordPress 5.0+ and WooCommerce 3.0+ for optimal functionality. 